/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import java.util.Collections;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

enum BuiltinQualifier {
    DEFAULT(AnnotationInstance.create((DotName)DotNames.DEFAULT, null, Collections.emptyList()), Default.Literal.class.getName()),
    ANY(AnnotationInstance.create((DotName)DotNames.ANY, null, Collections.emptyList()), Any.Literal.class.getName());

    static final Set<AnnotationInstance> DEFAULT_QUALIFIERS;
    private final AnnotationInstance instance;
    private final String literalType;

    private BuiltinQualifier(AnnotationInstance instance, String literalType) {
        this.instance = instance;
        this.literalType = literalType;
    }

    AnnotationInstance getInstance() {
        return this.instance;
    }

    ResultHandle getLiteralInstance(BytecodeCreator creator) {
        return creator.readStaticField(FieldDescriptor.of((String)this.literalType, (String)"INSTANCE", (String)this.literalType));
    }

    static BuiltinQualifier of(AnnotationInstance instance) {
        for (BuiltinQualifier qualifier : BuiltinQualifier.values()) {
            if (!qualifier.getInstance().name().equals((Object)instance.name())) continue;
            return qualifier;
        }
        return null;
    }

    static {
        DEFAULT_QUALIFIERS = Set.of(DEFAULT.getInstance(), ANY.getInstance());
    }
}

