/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.arc.impl.TypeVariableImpl;
import io.quarkus.arc.impl.TypeVariableReferenceImpl;
import io.quarkus.arc.impl.WildcardTypeImpl;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public final class Types {
    static final Logger LOGGER = Logger.getLogger(Types.class);
    private static final org.jboss.jandex.Type OBJECT_TYPE = org.jboss.jandex.Type.create((DotName)DotNames.OBJECT, (Type.Kind)Type.Kind.CLASS);
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Set.of("boolean", "byte", "short", "int", "long", "float", "double", "char");
    private static final Set<DotName> PRIMITIVE_WRAPPERS = Set.of(DotNames.BOOLEAN, DotNames.BYTE, DotNames.SHORT, DotNames.INTEGER, DotNames.LONG, DotNames.FLOAT, DotNames.DOUBLE, DotNames.CHARACTER);
    private static final Set<DotName> BANNED_INTERFACE_TYPES = Set.of(DotName.createSimple((String)"java.util.SequencedCollection"));

    private Types() {
    }

    public static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type) {
        return Types.getTypeHandle(creator, type, null);
    }

    public static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type, ResultHandle tccl) {
        AssignableResultHandle result = creator.createVariable(Object.class);
        TypeVariables typeVariables = new TypeVariables();
        Types.getTypeHandle(result, creator, type, tccl, null, typeVariables);
        typeVariables.patchReferences(creator);
        return result;
    }

    public static org.jboss.jandex.Type jandexType(Class<?> clazz) {
        if (clazz.isArray()) {
            int dimensions = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimensions;
                componentType = componentType.getComponentType();
            }
            return ArrayType.create((org.jboss.jandex.Type)Types.jandexType(componentType), (int)dimensions);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"void"), (Type.Kind)Type.Kind.VOID);
            }
            if (clazz == Boolean.TYPE) {
                return PrimitiveType.BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return PrimitiveType.BYTE;
            }
            if (clazz == Short.TYPE) {
                return PrimitiveType.SHORT;
            }
            if (clazz == Integer.TYPE) {
                return PrimitiveType.INT;
            }
            if (clazz == Long.TYPE) {
                return PrimitiveType.LONG;
            }
            if (clazz == Float.TYPE) {
                return PrimitiveType.FLOAT;
            }
            if (clazz == Double.TYPE) {
                return PrimitiveType.DOUBLE;
            }
            if (clazz == Character.TYPE) {
                return PrimitiveType.CHAR;
            }
            throw new IllegalArgumentException("Unknown primitive type " + clazz);
        }
        return org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)clazz.getName()), (Type.Kind)Type.Kind.CLASS);
    }

    public static org.jboss.jandex.Type jandexType(Type type) {
        if (type instanceof Class) {
            return Types.jandexType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            ParameterizedType.Builder builder = org.jboss.jandex.ParameterizedType.builder((Class)((Class)p.getRawType()));
            for (Type typeArgument : p.getActualTypeArguments()) {
                builder.addArgument(Types.jandexType(typeArgument));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    static void getTypeHandle(AssignableResultHandle variable, BytecodeCreator creator, org.jboss.jandex.Type type, ResultHandle tccl, TypeCache cache) {
        TypeVariables typeVariables = new TypeVariables();
        Types.getTypeHandle(variable, creator, type, tccl, cache, typeVariables);
        typeVariables.patchReferences(creator);
    }

    private static void getTypeHandle(AssignableResultHandle variable, BytecodeCreator creator, org.jboss.jandex.Type type, ResultHandle tccl, TypeCache cache, TypeVariables typeVariables) {
        block29: {
            block34: {
                block33: {
                    ResultHandle wildcardHandle;
                    block32: {
                        ResultHandle arrayHandle;
                        block31: {
                            block30: {
                                block28: {
                                    if (cache != null) {
                                        ResultHandle cachedType = cache.get(type, creator);
                                        BranchResult cachedNull = creator.ifNull(cachedType);
                                        cachedNull.falseBranch().assign(variable, cachedType);
                                        creator = cachedNull.trueBranch();
                                    }
                                    if (!Type.Kind.CLASS.equals((Object)type.kind())) break block28;
                                    String className = type.asClassType().name().toString();
                                    ResultHandle classHandle = Types.doLoadClass(creator, className, tccl);
                                    if (cache != null) {
                                        cache.put(type, classHandle, creator);
                                    }
                                    creator.assign(variable, classHandle);
                                    break block29;
                                }
                                if (!Type.Kind.TYPE_VARIABLE.equals((Object)type.kind())) break block30;
                                TypeVariable typeVariable = type.asTypeVariable();
                                String identifier = typeVariable.identifier();
                                ResultHandle typeVariableHandle = typeVariables.getTypeVariable(identifier);
                                if (typeVariableHandle == null) {
                                    ResultHandle boundsHandle;
                                    List bounds = typeVariable.bounds();
                                    if (bounds.isEmpty()) {
                                        boundsHandle = creator.newArray(Type.class, creator.load(0));
                                    } else {
                                        boundsHandle = creator.newArray(Type.class, creator.load(bounds.size()));
                                        for (int i = 0; i < bounds.size(); ++i) {
                                            AssignableResultHandle boundHandle = creator.createVariable(Object.class);
                                            Types.getTypeHandle(boundHandle, creator, (org.jboss.jandex.Type)bounds.get(i), tccl, cache, typeVariables);
                                            creator.writeArrayValue(boundsHandle, i, (ResultHandle)boundHandle);
                                        }
                                    }
                                    typeVariableHandle = creator.newInstance(MethodDescriptor.ofConstructor(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), new ResultHandle[]{creator.load(identifier), boundsHandle});
                                    if (cache != null) {
                                        cache.put((org.jboss.jandex.Type)typeVariable, typeVariableHandle, creator);
                                    }
                                    typeVariables.setTypeVariable(identifier, typeVariableHandle);
                                }
                                creator.assign(variable, typeVariableHandle);
                                break block29;
                            }
                            if (!Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind())) break block31;
                            Types.getParameterizedType(variable, creator, tccl, type.asParameterizedType(), cache, typeVariables);
                            break block29;
                        }
                        if (!Type.Kind.ARRAY.equals((Object)type.kind())) break block32;
                        ArrayType array = type.asArrayType();
                        org.jboss.jandex.Type elementType = Types.getArrayElementType(array);
                        if (elementType.kind() == Type.Kind.PRIMITIVE || elementType.kind() == Type.Kind.CLASS) {
                            arrayHandle = Types.doLoadClass(creator, array.name().toString(), tccl);
                        } else {
                            org.jboss.jandex.Type componentType = type.asArrayType().constituent();
                            AssignableResultHandle componentTypeHandle = creator.createVariable(Object.class);
                            Types.getTypeHandle(componentTypeHandle, creator, componentType, tccl, cache, typeVariables);
                            arrayHandle = creator.newInstance(MethodDescriptor.ofConstructor(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{componentTypeHandle});
                        }
                        if (cache != null) {
                            cache.put(type, arrayHandle, creator);
                        }
                        creator.assign(variable, arrayHandle);
                        break block29;
                    }
                    if (!Type.Kind.WILDCARD_TYPE.equals((Object)type.kind())) break block33;
                    org.jboss.jandex.WildcardType wildcardType = type.asWildcardType();
                    if (wildcardType.superBound() == null) {
                        AssignableResultHandle extendsBoundHandle = creator.createVariable(Object.class);
                        Types.getTypeHandle(extendsBoundHandle, creator, wildcardType.extendsBound(), tccl, cache, typeVariables);
                        wildcardHandle = creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{extendsBoundHandle});
                    } else {
                        AssignableResultHandle superBoundHandle = creator.createVariable(Object.class);
                        Types.getTypeHandle(superBoundHandle, creator, wildcardType.superBound(), tccl, cache, typeVariables);
                        wildcardHandle = creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{superBoundHandle});
                    }
                    if (cache != null) {
                        cache.put((org.jboss.jandex.Type)wildcardType, wildcardHandle, creator);
                    }
                    creator.assign(variable, wildcardHandle);
                    break block29;
                }
                if (!Type.Kind.PRIMITIVE.equals((Object)type.kind())) break block34;
                switch (type.asPrimitiveType().primitive()) {
                    case INT: {
                        creator.assign(variable, creator.loadClass(Integer.TYPE));
                        break block29;
                    }
                    case LONG: {
                        creator.assign(variable, creator.loadClass(Long.TYPE));
                        break block29;
                    }
                    case BOOLEAN: {
                        creator.assign(variable, creator.loadClass(Boolean.TYPE));
                        break block29;
                    }
                    case BYTE: {
                        creator.assign(variable, creator.loadClass(Byte.TYPE));
                        break block29;
                    }
                    case CHAR: {
                        creator.assign(variable, creator.loadClass(Character.TYPE));
                        break block29;
                    }
                    case DOUBLE: {
                        creator.assign(variable, creator.loadClass(Double.TYPE));
                        break block29;
                    }
                    case FLOAT: {
                        creator.assign(variable, creator.loadClass(Float.TYPE));
                        break block29;
                    }
                    case SHORT: {
                        creator.assign(variable, creator.loadClass(Short.TYPE));
                        break block29;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported primitive type: " + type);
                    }
                }
            }
            if (Type.Kind.VOID.equals((Object)type.kind())) {
                creator.assign(variable, creator.loadClass(Void.TYPE));
            } else if (Type.Kind.TYPE_VARIABLE_REFERENCE.equals((Object)type.kind())) {
                String identifier = type.asTypeVariableReference().identifier();
                ResultHandle typeVariableReferenceHandle = typeVariables.getTypeVariableReference(identifier);
                if (typeVariableReferenceHandle == null) {
                    typeVariableReferenceHandle = creator.newInstance(MethodDescriptor.ofConstructor(TypeVariableReferenceImpl.class, (Class[])new Class[]{String.class}), new ResultHandle[]{creator.load(identifier)});
                    typeVariables.setTypeVariableReference(identifier, typeVariableReferenceHandle);
                }
                creator.assign(variable, typeVariableReferenceHandle);
            } else {
                throw new IllegalArgumentException("Unsupported bean type: " + type.kind() + ", " + type);
            }
        }
    }

    private static void getParameterizedType(AssignableResultHandle variable, BytecodeCreator creator, ResultHandle tccl, org.jboss.jandex.ParameterizedType parameterizedType, TypeCache cache, TypeVariables typeVariables) {
        List arguments = parameterizedType.arguments();
        ResultHandle typeArgsHandle = creator.newArray(Type.class, creator.load(arguments.size()));
        for (int i = 0; i < arguments.size(); ++i) {
            AssignableResultHandle argumentHandle = creator.createVariable(Object.class);
            Types.getTypeHandle(argumentHandle, creator, (org.jboss.jandex.Type)arguments.get(i), tccl, cache, typeVariables);
            creator.writeArrayValue(typeArgsHandle, i, (ResultHandle)argumentHandle);
        }
        org.jboss.jandex.Type rawType = org.jboss.jandex.Type.create((DotName)parameterizedType.name(), (Type.Kind)Type.Kind.CLASS);
        ResultHandle rawTypeHandle = null;
        if (cache != null) {
            rawTypeHandle = cache.get(rawType, creator);
        }
        if (rawTypeHandle == null) {
            rawTypeHandle = Types.doLoadClass(creator, parameterizedType.name().toString(), tccl);
            if (cache != null) {
                cache.put(rawType, rawTypeHandle, creator);
            }
        }
        ResultHandle parameterizedTypeHandle = creator.newInstance(MethodDescriptor.ofConstructor(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class}), new ResultHandle[]{rawTypeHandle, typeArgsHandle});
        if (cache != null) {
            cache.put((org.jboss.jandex.Type)parameterizedType, parameterizedTypeHandle, creator);
        }
        creator.assign(variable, parameterizedTypeHandle);
    }

    public static void getParameterizedType(AssignableResultHandle variable, BytecodeCreator creator, ResultHandle tccl, org.jboss.jandex.ParameterizedType parameterizedType) {
        TypeVariables typeVariables = new TypeVariables();
        Types.getParameterizedType(variable, creator, tccl, parameterizedType, null, typeVariables);
        typeVariables.patchReferences(creator);
    }

    public static ResultHandle getParameterizedType(BytecodeCreator creator, ResultHandle tccl, org.jboss.jandex.ParameterizedType parameterizedType) {
        AssignableResultHandle result = creator.createVariable(Object.class);
        TypeVariables typeVariables = new TypeVariables();
        Types.getParameterizedType(result, creator, tccl, parameterizedType, null, typeVariables);
        typeVariables.patchReferences(creator);
        return result;
    }

    private static ResultHandle doLoadClass(BytecodeCreator creator, String className, ResultHandle tccl) {
        if (className.startsWith("java.")) {
            return creator.loadClass(className);
        }
        if (tccl == null) {
            ResultHandle currentThread = creator.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
            tccl = creator.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        }
        return creator.invokeStaticMethod(MethodDescriptors.CL_FOR_NAME, new ResultHandle[]{creator.load(className), creator.load(false), tccl});
    }

    static org.jboss.jandex.Type getProviderType(ClassInfo classInfo) {
        List typeParameters = classInfo.typeParameters();
        if (!typeParameters.isEmpty()) {
            return org.jboss.jandex.ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParameters.toArray(new org.jboss.jandex.Type[0]), null);
        }
        return org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
    }

    static org.jboss.jandex.Type getArrayElementType(ArrayType array) {
        org.jboss.jandex.Type elementType = array.constituent();
        while (elementType.kind() == Type.Kind.ARRAY) {
            elementType = elementType.asArrayType().constituent();
        }
        return elementType;
    }

    static TypeClosure getProducerMethodTypeClosure(MethodInfo producerMethod, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        HashSet<org.jboss.jandex.Type> unrestrictedBeanTypes = new HashSet<org.jboss.jandex.Type>();
        org.jboss.jandex.Type returnType = producerMethod.returnType();
        if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
            throw new DefinitionException("A type variable is not a legal bean type: " + producerMethod);
        }
        if (returnType.kind() == Type.Kind.ARRAY) {
            Types.checkArrayType(returnType.asArrayType(), (AnnotationTarget)producerMethod);
        }
        if (returnType.kind() == Type.Kind.PRIMITIVE || returnType.kind() == Type.Kind.ARRAY) {
            HashSet<org.jboss.jandex.Type> types2 = new HashSet<org.jboss.jandex.Type>();
            types2.add(returnType);
            types2.add(OBJECT_TYPE);
            return new TypeClosure(types2);
        }
        ClassInfo returnTypeClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), returnType);
        if (returnTypeClassInfo == null) {
            throw new IllegalArgumentException("Producer method return type not found in index: " + producerMethod.returnType().name());
        }
        if (Type.Kind.CLASS.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Collections.emptyMap(), beanDeployment, null, unrestrictedBeanTypes);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Types.buildResolvedMap(returnType.asParameterizedType().arguments(), returnTypeClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null, unrestrictedBeanTypes);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return new TypeClosure(Types.restrictBeanTypes(types, unrestrictedBeanTypes, beanDeployment.getAnnotations((AnnotationTarget)producerMethod), beanDeployment.getBeanArchiveIndex(), (AnnotationTarget)producerMethod), unrestrictedBeanTypes);
    }

    static TypeClosure getProducerFieldTypeClosure(FieldInfo producerField, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        HashSet<org.jboss.jandex.Type> unrestrictedBeanTypes = new HashSet<org.jboss.jandex.Type>();
        org.jboss.jandex.Type fieldType = producerField.type();
        if (fieldType.kind() == Type.Kind.TYPE_VARIABLE) {
            throw new DefinitionException("A type variable is not a legal bean type: " + producerField);
        }
        if (fieldType.kind() == Type.Kind.ARRAY) {
            Types.checkArrayType(fieldType.asArrayType(), (AnnotationTarget)producerField);
        }
        if (fieldType.kind() == Type.Kind.PRIMITIVE || fieldType.kind() == Type.Kind.ARRAY) {
            HashSet<org.jboss.jandex.Type> types2 = new HashSet<org.jboss.jandex.Type>();
            types2.add(fieldType);
            types2.add(OBJECT_TYPE);
            return new TypeClosure(types2);
        }
        ClassInfo fieldClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), producerField.type());
        if (fieldClassInfo == null) {
            throw new IllegalArgumentException("Producer field type not found in index: " + producerField.type().name());
        }
        if (Type.Kind.CLASS.equals((Object)fieldType.kind())) {
            types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Collections.emptyMap(), beanDeployment, null, unrestrictedBeanTypes);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)fieldType.kind())) {
            types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Types.buildResolvedMap(fieldType.asParameterizedType().arguments(), fieldClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null, unrestrictedBeanTypes);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return new TypeClosure(Types.restrictBeanTypes(types, unrestrictedBeanTypes, beanDeployment.getAnnotations((AnnotationTarget)producerField), beanDeployment.getBeanArchiveIndex(), (AnnotationTarget)producerField), unrestrictedBeanTypes);
    }

    static TypeClosure getClassBeanTypeClosure(ClassInfo classInfo, BeanDeployment beanDeployment) {
        HashSet<org.jboss.jandex.Type> unrestrictedBeanTypes = new HashSet<org.jboss.jandex.Type>();
        List typeParameters = classInfo.typeParameters();
        Set<org.jboss.jandex.Type> types = typeParameters.isEmpty() ? Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, null, unrestrictedBeanTypes) : Types.getTypeClosure(classInfo, null, Types.buildResolvedMap(typeParameters, typeParameters, Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null, unrestrictedBeanTypes);
        return new TypeClosure(Types.restrictBeanTypes(types, unrestrictedBeanTypes, beanDeployment.getAnnotations((AnnotationTarget)classInfo), beanDeployment.getBeanArchiveIndex(), (AnnotationTarget)classInfo), unrestrictedBeanTypes);
    }

    static Set<org.jboss.jandex.Type> getClassUnrestrictedTypeClosure(ClassInfo classInfo, BeanDeployment beanDeployment) {
        HashSet<org.jboss.jandex.Type> unrestrictedBeanTypes = new HashSet<org.jboss.jandex.Type>();
        List typeParameters = classInfo.typeParameters();
        Set<org.jboss.jandex.Type> types = typeParameters.isEmpty() ? Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, null, unrestrictedBeanTypes) : Types.getTypeClosure(classInfo, null, Types.buildResolvedMap(typeParameters, typeParameters, Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null, unrestrictedBeanTypes);
        return types;
    }

    static Map<String, org.jboss.jandex.Type> resolveDecoratedTypeParams(ClassInfo decoratedTypeClass, DecoratorInfo decorator) {
        List typeParameters = decoratedTypeClass.typeParameters();
        Map<String, org.jboss.jandex.Type> resolvedTypeParameters = Collections.emptyMap();
        if (!typeParameters.isEmpty()) {
            resolvedTypeParameters = new HashMap<String, org.jboss.jandex.Type>();
            org.jboss.jandex.Type type = decorator.getDelegateType();
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                List typeArguments = type.asParameterizedType().arguments();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    resolvedTypeParameters.put(((TypeVariable)typeParameters.get(i)).identifier(), (org.jboss.jandex.Type)typeArguments.get(i));
                }
            }
        }
        return resolvedTypeParameters;
    }

    static List<org.jboss.jandex.Type> getResolvedParameters(ClassInfo classInfo, Map<String, org.jboss.jandex.Type> resolvedMap, MethodInfo method, IndexView index) {
        List typeParameters = classInfo.typeParameters();
        List parameters = method.parameterTypes();
        if (typeParameters.isEmpty()) {
            return parameters;
        }
        resolvedMap = Types.buildResolvedMap(typeParameters, typeParameters, resolvedMap, index);
        ArrayList<org.jboss.jandex.Type> resolved = new ArrayList<org.jboss.jandex.Type>();
        for (org.jboss.jandex.Type param : parameters) {
            switch (param.kind()) {
                case ARRAY: 
                case PRIMITIVE: 
                case CLASS: {
                    resolved.add(param);
                    break;
                }
                case TYPE_VARIABLE: 
                case PARAMETERIZED_TYPE: {
                    resolved.add(Types.resolveTypeParam(param, resolvedMap, index));
                }
            }
        }
        return resolved;
    }

    static void checkArrayType(ArrayType arrayType, AnnotationTarget producerFieldOrMethod) {
        org.jboss.jandex.Type elementType = Types.getArrayElementType(arrayType);
        if (elementType.kind() == Type.Kind.TYPE_VARIABLE) {
            throw new DefinitionException("A type variable array is not a legal bean type: " + producerFieldOrMethod);
        }
        Types.containsWildcard(elementType, producerFieldOrMethod, true);
    }

    static boolean containsWildcard(org.jboss.jandex.Type type, AnnotationTarget producerFieldOrMethod, boolean throwIfDetected) {
        if (type.kind().equals((Object)Type.Kind.WILDCARD_TYPE)) {
            if (throwIfDetected && producerFieldOrMethod != null) {
                throw new DefinitionException("Producer " + (producerFieldOrMethod.kind().equals((Object)AnnotationTarget.Kind.FIELD) ? "field " : "method ") + producerFieldOrMethod + " declared on class " + (producerFieldOrMethod.kind().equals((Object)AnnotationTarget.Kind.FIELD) ? producerFieldOrMethod.asField().declaringClass().name() : producerFieldOrMethod.asMethod().declaringClass().name()) + " contains a parameterized type with a wildcard. This type is not a legal bean type according to CDI specification.");
            }
            return true;
        }
        if (type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            boolean wildcardFound = false;
            for (org.jboss.jandex.Type t : type.asParameterizedType().arguments()) {
                wildcardFound = Types.containsWildcard(t, producerFieldOrMethod, throwIfDetected);
                if (!wildcardFound) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<org.jboss.jandex.Type> getTypeClosure(ClassInfo classInfo, AnnotationTarget producerFieldOrMethod, boolean throwOnProducerWildcard, Map<String, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment, BiConsumer<ClassInfo, Map<String, org.jboss.jandex.Type>> resolvedTypeVariablesConsumer, Set<org.jboss.jandex.Type> unrestrictedBeanTypes, boolean rawGeneric) {
        ClassInfo superClassInfo;
        HashSet<org.jboss.jandex.Type> types = new HashSet<org.jboss.jandex.Type>();
        List typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty() || !typeParameters.stream().allMatch(it -> resolvedTypeParameters.containsKey(it.identifier())) || rawGeneric) {
            types.add(org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        } else {
            org.jboss.jandex.Type[] typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            boolean skipThisType = false;
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = resolvedTypeParameters.get(((TypeVariable)typeParameters.get(i)).identifier());
                skipThisType = Types.containsWildcard((org.jboss.jandex.Type)typeParams[i], producerFieldOrMethod, throwOnProducerWildcard);
            }
            if (resolvedTypeVariablesConsumer != null) {
                HashMap<String, Object> resolved = new HashMap<String, Object>();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    resolved.put(((TypeVariable)typeParameters.get(i)).identifier(), typeParams[i]);
                }
                resolvedTypeVariablesConsumer.accept(classInfo, resolved);
            }
            if (!skipThisType) {
                types.add((org.jboss.jandex.Type)org.jboss.jandex.ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParams, null));
            } else {
                unrestrictedBeanTypes.add((org.jboss.jandex.Type)org.jboss.jandex.ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParams, null));
            }
        }
        for (org.jboss.jandex.Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo;
            if (BANNED_INTERFACE_TYPES.contains(interfaceType.name()) || (interfaceClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), interfaceType.name())) == null) continue;
            Map<String, org.jboss.jandex.Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getBeanArchiveIndex());
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, producerFieldOrMethod, false, resolved, beanDeployment, resolvedTypeVariablesConsumer, unrestrictedBeanTypes, rawGeneric || Types.isRawGeneric(interfaceType, interfaceClassInfo)));
        }
        if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            Map<String, org.jboss.jandex.Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getBeanArchiveIndex());
            }
            types.addAll(Types.getTypeClosure(superClassInfo, producerFieldOrMethod, false, resolved, beanDeployment, resolvedTypeVariablesConsumer, unrestrictedBeanTypes, rawGeneric || Types.isRawGeneric(classInfo.superClassType(), superClassInfo)));
        }
        unrestrictedBeanTypes.addAll(types);
        return types;
    }

    private static boolean isRawGeneric(org.jboss.jandex.Type superClassType, ClassInfo superClassInfo) {
        return Type.Kind.CLASS.equals((Object)superClassType.kind()) && !superClassInfo.typeParameters().isEmpty();
    }

    static Set<org.jboss.jandex.Type> getTypeClosure(ClassInfo classInfo, AnnotationTarget producerFieldOrMethod, Map<String, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment, BiConsumer<ClassInfo, Map<String, org.jboss.jandex.Type>> resolvedTypeVariablesConsumer, Set<org.jboss.jandex.Type> unrestrictedBeanTypes) {
        return Types.getTypeClosure(classInfo, producerFieldOrMethod, true, resolvedTypeParameters, beanDeployment, resolvedTypeVariablesConsumer, unrestrictedBeanTypes, false);
    }

    static Set<org.jboss.jandex.Type> getDelegateTypeClosure(InjectionPointInfo delegateInjectionPoint, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        HashSet<org.jboss.jandex.Type> unrestrictedBeanTypes = new HashSet<org.jboss.jandex.Type>();
        org.jboss.jandex.Type delegateType = delegateInjectionPoint.getRequiredType();
        if (delegateType.kind() == Type.Kind.TYPE_VARIABLE || delegateType.kind() == Type.Kind.PRIMITIVE || delegateType.kind() == Type.Kind.ARRAY) {
            throw new DefinitionException("Illegal delegate type declared:" + delegateInjectionPoint.getTargetInfo());
        }
        ClassInfo delegateTypeClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), delegateType);
        if (delegateTypeClass == null) {
            throw new IllegalArgumentException("Delegate type not found in index: " + delegateType);
        }
        if (Type.Kind.CLASS.equals((Object)delegateType.kind())) {
            types = Types.getTypeClosure(delegateTypeClass, delegateInjectionPoint.getTarget(), Collections.emptyMap(), beanDeployment, null, unrestrictedBeanTypes);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)delegateType.kind())) {
            types = Types.getTypeClosure(delegateTypeClass, delegateInjectionPoint.getTarget(), Types.buildResolvedMap(delegateType.asParameterizedType().arguments(), delegateTypeClass.typeParameters(), Collections.emptyMap(), beanDeployment.getBeanArchiveIndex()), beanDeployment, null, unrestrictedBeanTypes);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return types;
    }

    static Map<ClassInfo, Map<String, org.jboss.jandex.Type>> resolvedTypeVariables(ClassInfo classInfo, BeanDeployment beanDeployment) {
        HashMap<ClassInfo, Map<String, org.jboss.jandex.Type>> resolvedTypeVariables = new HashMap<ClassInfo, Map<String, org.jboss.jandex.Type>>();
        Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, resolvedTypeVariables::put, new HashSet<org.jboss.jandex.Type>());
        return resolvedTypeVariables;
    }

    static Set<org.jboss.jandex.Type> restrictBeanTypes(Set<org.jboss.jandex.Type> types, Set<org.jboss.jandex.Type> unrestrictedBeanTypes, Collection<AnnotationInstance> annotations, IndexView index, AnnotationTarget target) {
        AnnotationInstance typed = null;
        for (AnnotationInstance a : annotations) {
            if (!a.name().equals((Object)DotNames.TYPED)) continue;
            typed = a;
            break;
        }
        Set<DotName> typedClasses = Collections.emptySet();
        if (typed != null) {
            AnnotationValue typedValue = typed.value();
            if (typedValue == null) {
                types.clear();
                types.add(OBJECT_TYPE);
            } else {
                typedClasses = new HashSet<DotName>();
                for (org.jboss.jandex.Type type2 : typedValue.asClassArray()) {
                    typedClasses.add(type2.name());
                }
            }
        }
        for (DotName typeName : typedClasses) {
            if (unrestrictedBeanTypes.stream().anyMatch(type -> type.name().equals((Object)typeName))) continue;
            throw new DefinitionException("Cannot limit bean types to types outside of the transitive closure of bean types. Bean: " + target + " illegal bean types: " + typedClasses);
        }
        Iterator<org.jboss.jandex.Type> it = types.iterator();
        while (it.hasNext()) {
            ClassInfo classInfo;
            org.jboss.jandex.Type next = it.next();
            if (DotNames.OBJECT.equals((Object)next.name())) continue;
            if (typed != null && !typedClasses.contains(next.name())) {
                it.remove();
                continue;
            }
            String className = next.name().toString();
            if (!className.startsWith("java.") || (classInfo = index.getClassByName(next.name())) != null && Modifier.isPublic(classInfo.flags())) continue;
            it.remove();
        }
        return types;
    }

    static <T extends org.jboss.jandex.Type> Map<String, org.jboss.jandex.Type> buildResolvedMap(List<T> resolvedArguments, List<TypeVariable> typeVariables, Map<String, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        HashMap<String, org.jboss.jandex.Type> resolvedMap = new HashMap<String, org.jboss.jandex.Type>();
        for (int i = 0; i < resolvedArguments.size(); ++i) {
            resolvedMap.put(typeVariables.get(i).identifier(), Types.resolveTypeParam((org.jboss.jandex.Type)resolvedArguments.get(i), resolvedTypeParameters, index));
        }
        return resolvedMap;
    }

    static org.jboss.jandex.Type resolveTypeParam(org.jboss.jandex.Type typeParam, Map<String, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        org.jboss.jandex.ParameterizedType parameterizedType;
        ClassInfo classInfo;
        if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
            return resolvedTypeParameters.getOrDefault(typeParam.asTypeVariable().identifier(), typeParam);
        }
        if (typeParam.kind() == Type.Kind.PARAMETERIZED_TYPE && (classInfo = IndexClassLookupUtils.getClassByName(index, (parameterizedType = typeParam.asParameterizedType()).name())) != null) {
            List typeParameters = classInfo.typeParameters();
            List arguments = parameterizedType.arguments();
            Map<String, org.jboss.jandex.Type> resolvedMap = Types.buildResolvedMap(arguments, typeParameters, resolvedTypeParameters, index);
            org.jboss.jandex.Type[] typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = Types.resolveTypeParam((org.jboss.jandex.Type)typeParameters.get(i), resolvedMap, index);
            }
            return org.jboss.jandex.ParameterizedType.create((DotName)parameterizedType.name(), (org.jboss.jandex.Type[])typeParams, null);
        }
        return typeParam;
    }

    static String getPackageName(String className) {
        return (className = className.replace('/', '.')).contains(".") ? className.substring(0, className.lastIndexOf(".")) : "";
    }

    static String getSimpleName(String className) {
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1, className.length()) : className;
    }

    static org.jboss.jandex.Type box(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return Types.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static org.jboss.jandex.Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return org.jboss.jandex.Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return org.jboss.jandex.Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }

    static boolean isPrimitiveClassName(String className) {
        return PRIMITIVE_CLASS_NAMES.contains(className);
    }

    static boolean isPrimitiveWrapperType(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.CLASS) {
            return PRIMITIVE_WRAPPERS.contains(type.name());
        }
        return false;
    }

    static ResultHandle loadPrimitiveDefault(PrimitiveType.Primitive primitive, BytecodeCreator bytecode) {
        switch (Objects.requireNonNull(primitive)) {
            case BOOLEAN: {
                return bytecode.load(false);
            }
            case BYTE: {
                return bytecode.load((byte)0);
            }
            case SHORT: {
                return bytecode.load((short)0);
            }
            case INT: {
                return bytecode.load(0);
            }
            case LONG: {
                return bytecode.load(0L);
            }
            case FLOAT: {
                return bytecode.load(0.0f);
            }
            case DOUBLE: {
                return bytecode.load(0.0);
            }
            case CHAR: {
                return bytecode.load('\u0000');
            }
        }
        throw new IllegalArgumentException("Unknown primitive type: " + primitive);
    }

    static boolean containsTypeVariable(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            return true;
        }
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (org.jboss.jandex.Type arg : type.asParameterizedType().arguments()) {
                if (!Types.containsTypeVariable(arg)) continue;
                return true;
            }
        }
        return false;
    }

    private static class TypeVariables {
        private final Map<String, ResultHandle> typeVariable = new HashMap<String, ResultHandle>();
        private final Map<String, ResultHandle> typeVariableReference = new HashMap<String, ResultHandle>();

        private TypeVariables() {
        }

        ResultHandle getTypeVariable(String identifier) {
            return this.typeVariable.get(identifier);
        }

        void setTypeVariable(String identifier, ResultHandle handle) {
            this.typeVariable.put(identifier, handle);
        }

        ResultHandle getTypeVariableReference(String identifier) {
            return this.typeVariableReference.get(identifier);
        }

        void setTypeVariableReference(String identifier, ResultHandle handle) {
            this.typeVariableReference.put(identifier, handle);
        }

        void patchReferences(BytecodeCreator creator) {
            this.typeVariableReference.forEach((identifier, reference) -> {
                ResultHandle typeVar = this.typeVariable.get(identifier);
                if (typeVar != null) {
                    creator.invokeVirtualMethod(MethodDescriptor.ofMethod(TypeVariableReferenceImpl.class, (String)"setDelegate", Void.TYPE, (Class[])new Class[]{TypeVariableImpl.class}), reference, new ResultHandle[]{typeVar});
                }
            });
        }
    }

    static interface TypeCache {
        public void initialize(MethodCreator var1);

        public ResultHandle get(org.jboss.jandex.Type var1, BytecodeCreator var2);

        public void put(org.jboss.jandex.Type var1, ResultHandle var2, BytecodeCreator var3);
    }

    record TypeClosure(Set<org.jboss.jandex.Type> types, Set<org.jboss.jandex.Type> unrestrictedTypes) {
        TypeClosure(Set<org.jboss.jandex.Type> types) {
            this(types, types);
        }
    }
}

