/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.Types;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class InjectionPointInfo {
    private final TypeAndQualifiers typeAndQualifiers;
    private final AtomicReference<BeanInfo> resolvedBean;
    private final AtomicReference<BeanInfo> targetBean;
    private final InjectionPointKind kind;
    private final boolean hasDefaultQualifier;
    private final AnnotationTarget target;
    private final int position;
    private final boolean isTransientReference;
    private final boolean isDelegate;

    private static boolean isNamedWithoutValue(AnnotationInstance annotation) {
        if (annotation.name().equals((Object)DotNames.NAMED)) {
            AnnotationValue name = annotation.value();
            return name == null || name.asString().isEmpty();
        }
        return false;
    }

    static InjectionPointInfo fromField(FieldInfo field, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        Collection<AnnotationInstance> annotations = beanDeployment.getAnnotations((AnnotationTarget)field);
        for (AnnotationInstance annotation : annotations) {
            for (AnnotationInstance annotationInstance : beanDeployment.extractQualifiers(annotation)) {
                if (InjectionPointInfo.isNamedWithoutValue(annotationInstance)) {
                    annotationInstance = AnnotationInstance.builder((DotName)annotationInstance.name()).value(field.name()).buildWithTarget(annotationInstance.target());
                }
                qualifiers.add(annotationInstance);
            }
        }
        Type type = InjectionPointInfo.resolveType(field.type(), beanClass, field.declaringClass(), beanDeployment);
        return new InjectionPointInfo(type, transformer.applyTransformers(type, (AnnotationTarget)field, qualifiers), (AnnotationTarget)field, -1, Annotations.contains(annotations, DotNames.TRANSIENT_REFERENCE), Annotations.contains(annotations, DotNames.DELEGATE));
    }

    static InjectionPointInfo fromResourceField(FieldInfo field, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        Type type = InjectionPointInfo.resolveType(field.type(), beanClass, field.declaringClass(), beanDeployment);
        return new InjectionPointInfo(type, transformer.applyTransformers(type, (AnnotationTarget)field, new HashSet<AnnotationInstance>(Annotations.onlyRuntimeVisible(field.annotations()))), InjectionPointKind.RESOURCE, (AnnotationTarget)field, -1, false, false);
    }

    static List<InjectionPointInfo> fromMethod(MethodInfo method, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        return InjectionPointInfo.fromMethod(method, beanClass, beanDeployment, null, transformer);
    }

    static List<InjectionPointInfo> fromMethod(MethodInfo method, ClassInfo beanClass, BeanDeployment beanDeployment, Predicate<Set<AnnotationInstance>> skipPredicate, InjectionPointModifier transformer) {
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        ListIterator iterator = method.parameterTypes().listIterator();
        while (iterator.hasNext()) {
            Type paramType = (Type)iterator.next();
            int position = iterator.previousIndex();
            Set<AnnotationInstance> paramAnnotations = Annotations.getParameterAnnotations(beanDeployment, method, position);
            if (skipPredicate != null && skipPredicate.test(paramAnnotations)) continue;
            HashSet<AnnotationInstance> paramQualifiers = new HashSet<AnnotationInstance>();
            for (AnnotationInstance paramAnnotation : paramAnnotations) {
                for (AnnotationInstance annotationInstance : beanDeployment.extractQualifiers(paramAnnotation)) {
                    if (InjectionPointInfo.isNamedWithoutValue(annotationInstance)) {
                        throw new DefinitionException("@Named without value may not be used on method parameter: " + method);
                    }
                    paramQualifiers.add(annotationInstance);
                }
            }
            Type type = InjectionPointInfo.resolveType(paramType, beanClass, method.declaringClass(), beanDeployment);
            injectionPoints.add(new InjectionPointInfo(type, transformer.applyTransformers(type, (AnnotationTarget)method, paramQualifiers), (AnnotationTarget)method, position, Annotations.contains(paramAnnotations, DotNames.TRANSIENT_REFERENCE), Annotations.contains(paramAnnotations, DotNames.DELEGATE)));
        }
        return injectionPoints;
    }

    static InjectionPointInfo fromSyntheticInjectionPoint(TypeAndQualifiers typeAndQualifiers) {
        return new InjectionPointInfo(typeAndQualifiers, InjectionPointKind.CDI, null, -1, false, false);
    }

    InjectionPointInfo(Type requiredType, Set<AnnotationInstance> requiredQualifiers, AnnotationTarget target, int position, boolean isTransientReference, boolean isDelegate) {
        this(requiredType, requiredQualifiers, InjectionPointKind.CDI, target, position, isTransientReference, isDelegate);
    }

    InjectionPointInfo(Type requiredType, Set<AnnotationInstance> requiredQualifiers, InjectionPointKind kind, AnnotationTarget target, int position, boolean isTransientReference, boolean isDelegate) {
        this(new TypeAndQualifiers(requiredType, requiredQualifiers.isEmpty() ? Collections.singleton(AnnotationInstance.create((DotName)DotNames.DEFAULT, null, Collections.emptyList())) : requiredQualifiers), kind, target, position, isTransientReference, isDelegate);
    }

    InjectionPointInfo(TypeAndQualifiers typeAndQualifiers, InjectionPointKind kind, AnnotationTarget target, int position, boolean isTransientReference, boolean isDelegate) {
        this.typeAndQualifiers = typeAndQualifiers;
        this.resolvedBean = new AtomicReference<Object>(null);
        this.targetBean = new AtomicReference<Object>(null);
        this.kind = kind;
        this.hasDefaultQualifier = typeAndQualifiers.qualifiers.size() == 1 && typeAndQualifiers.qualifiers.iterator().next().name().equals((Object)DotNames.DEFAULT);
        this.target = target;
        this.position = position;
        this.isTransientReference = isTransientReference;
        this.isDelegate = isDelegate;
        if (DotNames.EVENT.equals((Object)typeAndQualifiers.type.name()) && typeAndQualifiers.type.kind() == Type.Kind.CLASS) {
            throw new DefinitionException("Event injection point can never be raw type - please specify the type parameter. Injection point: " + target);
        }
    }

    void resolve(BeanInfo bean) {
        this.resolvedBean.set(bean);
    }

    public BeanInfo getResolvedBean() {
        return this.resolvedBean.get();
    }

    public Optional<BeanInfo> getTargetBean() {
        return Optional.ofNullable(this.targetBean.get());
    }

    public void setTargetBean(BeanInfo bean) {
        this.targetBean.set(bean);
    }

    InjectionPointKind getKind() {
        return this.kind;
    }

    public Type getRequiredType() {
        Type requiredType = this.typeAndQualifiers.type;
        if (this.isProgrammaticLookup() && requiredType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            requiredType = (Type)requiredType.asParameterizedType().arguments().get(0);
        }
        return requiredType;
    }

    public Type getType() {
        return this.typeAndQualifiers.type;
    }

    public boolean isProgrammaticLookup() {
        DotName requiredTypeName = this.typeAndQualifiers.type.name();
        return DotNames.INSTANCE.equals((Object)requiredTypeName) || DotNames.INJECTABLE_INSTANCE.equals((Object)requiredTypeName) || DotNames.PROVIDER.equals((Object)requiredTypeName);
    }

    public Set<AnnotationInstance> getRequiredQualifiers() {
        return this.typeAndQualifiers.qualifiers;
    }

    public AnnotationInstance getRequiredQualifier(DotName name) {
        for (AnnotationInstance qualifier : this.typeAndQualifiers.qualifiers) {
            if (!qualifier.name().equals((Object)name)) continue;
            return qualifier;
        }
        return null;
    }

    public boolean hasDefaultedQualifier() {
        return this.hasDefaultQualifier;
    }

    TypeAndQualifiers getTypeAndQualifiers() {
        return this.typeAndQualifiers;
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public boolean isField() {
        return this.target != null && this.target.kind() == AnnotationTarget.Kind.FIELD;
    }

    public boolean isParam() {
        return this.target != null && this.target.kind() == AnnotationTarget.Kind.METHOD;
    }

    boolean isDependentTransientReference() {
        BeanInfo bean = this.getResolvedBean();
        return bean != null && this.isParam() && BuiltinScope.DEPENDENT.is(bean.getScope()) && this.isTransientReference;
    }

    public boolean isTransientReference() {
        return this.isTransientReference;
    }

    public boolean isDelegate() {
        return this.isDelegate;
    }

    public boolean hasResolvedBean() {
        return this.resolvedBean.get() != null;
    }

    public int getPosition() {
        return this.position;
    }

    public String getTargetInfo() {
        if (this.target == null) {
            return "";
        }
        switch (this.target.kind()) {
            case FIELD: {
                return this.target.asField().declaringClass().name() + "#" + this.target.asField().name();
            }
            case METHOD: {
                Object method;
                Object param = this.target.asMethod().parameterName(this.position);
                if (param == null || ((String)param).isBlank()) {
                    param = "arg" + this.position;
                }
                method = ((String)(method = this.target.asMethod().name())).equals("<init>") ? "" : "#" + (String)method;
                return this.target.asMethod().declaringClass().name() + (String)method + "():" + (String)param;
            }
        }
        return this.target.toString();
    }

    public boolean isSynthetic() {
        return this.target == null;
    }

    boolean isCurrentInjectionPointWrapperNeeded() {
        BeanInfo bean = this.getResolvedBean();
        if (bean != null && BuiltinScope.DEPENDENT.is(bean.getScope())) {
            return bean.isSynthetic() || bean.requiresInjectionPointMetadata();
        }
        return false;
    }

    public String toString() {
        return "InjectionPointInfo [requiredType=" + this.typeAndQualifiers.type + ", requiredQualifiers=" + this.typeAndQualifiers.qualifiers + "]";
    }

    private static Type resolveType(Type type, ClassInfo beanClass, ClassInfo declaringClass, BeanDeployment beanDeployment) {
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.CLASS) {
            return type;
        }
        Map<ClassInfo, Map<String, Type>> resolvedTypeVariables = Types.resolvedTypeVariables(beanClass, beanDeployment);
        return InjectionPointInfo.resolveType(type, declaringClass, beanDeployment, resolvedTypeVariables);
    }

    private static Type resolveType(Type type, ClassInfo beanClass, BeanDeployment beanDeployment, Map<ClassInfo, Map<String, Type>> resolvedTypeVariables) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            if (resolvedTypeVariables.containsKey(beanClass)) {
                return resolvedTypeVariables.get(beanClass).getOrDefault(type.asTypeVariable().identifier(), type);
            }
        } else {
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type[] typeParams = new Type[parameterizedType.arguments().size()];
                for (int i = 0; i < typeParams.length; ++i) {
                    Type argument = (Type)parameterizedType.arguments().get(i);
                    typeParams[i] = argument.kind() == Type.Kind.TYPE_VARIABLE || argument.kind() == Type.Kind.PARAMETERIZED_TYPE ? InjectionPointInfo.resolveType(argument, beanClass, beanDeployment, resolvedTypeVariables) : argument;
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])typeParams, (Type)parameterizedType.owner());
            }
            if (type.kind() == Type.Kind.ARRAY) {
                ArrayType arrayType = type.asArrayType();
                Type component = arrayType.component();
                if (component.kind() == Type.Kind.TYPE_VARIABLE || component.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    component = InjectionPointInfo.resolveType(component, beanClass, beanDeployment, resolvedTypeVariables);
                }
                return ArrayType.create((Type)component, (int)type.asArrayType().dimensions());
            }
        }
        return type;
    }

    public static class TypeAndQualifiers {
        public final Type type;
        public final Set<AnnotationInstance> qualifiers;

        public TypeAndQualifiers(Type type, Set<AnnotationInstance> qualifiers) {
            this.type = type;
            this.qualifiers = qualifiers;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAndQualifiers other = (TypeAndQualifiers)obj;
            if (this.qualifiers == null ? other.qualifiers != null : !this.qualifiers.equals(other.qualifiers)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    static enum InjectionPointKind {
        CDI,
        RESOURCE;

    }
}

