/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.DecoratorDelegateProvider;
import io.quarkus.arc.impl.InitializedInterceptor;
import io.quarkus.arc.impl.SyntheticCreationalContextImpl;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.arc.processor.SyntheticComponentsUtil;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.IllegalProductException;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class BeanGenerator
extends AbstractGenerator {
    static final String BEAN_SUFFIX = "_Bean";
    static final String PRODUCER_METHOD_SUFFIX = "_ProducerMethod";
    static final String PRODUCER_FIELD_SUFFIX = "_ProducerField";
    protected static final String FIELD_NAME_DECLARING_PROVIDER_SUPPLIER = "declaringProviderSupplier";
    protected static final String FIELD_NAME_BEAN_TYPES = "types";
    protected static final String FIELD_NAME_QUALIFIERS = "qualifiers";
    protected static final String FIELD_NAME_STEREOTYPES = "stereotypes";
    protected static final String FIELD_NAME_PROXY = "proxy";
    protected final AnnotationLiteralProcessor annotationLiterals;
    protected final Predicate<DotName> applicationClassPredicate;
    protected final BeanProcessor.PrivateMembersCollector privateMembers;
    protected final Set<String> existingClasses;
    protected final Map<BeanInfo, String> beanToGeneratedName;
    protected final Map<BeanInfo, String> beanToGeneratedBaseName;
    protected final Predicate<DotName> injectionPointAnnotationsPredicate;
    protected final List<Function<BeanInfo, Consumer<BytecodeCreator>>> suppressConditionGenerators;

    public BeanGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate, List<Function<BeanInfo, Consumer<BytecodeCreator>>> suppressConditionGenerators) {
        super(generateSources, reflectionRegistration);
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
        this.existingClasses = existingClasses;
        this.beanToGeneratedName = beanToGeneratedName;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.suppressConditionGenerators = suppressConditionGenerators;
        this.beanToGeneratedBaseName = new HashMap<BeanInfo, String>();
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean) {
        if (bean.getTarget().isPresent()) {
            AnnotationTarget target = bean.getTarget().get();
            switch (target.kind()) {
                case CLASS: {
                    return this.generateClassBean(bean, target.asClass());
                }
                case METHOD: {
                    return this.generateProducerMethodBean(bean, target.asMethod());
                }
                case FIELD: {
                    return this.generateProducerFieldBean(bean, target.asField());
                }
            }
            throw new IllegalArgumentException("Unsupported bean type");
        }
        return this.generateSyntheticBean(bean);
    }

    void precomputeGeneratedName(BeanInfo bean) {
        if (bean.isSynthetic()) {
            this.generateSyntheticBeanName(bean);
        } else if (bean.isProducerField()) {
            this.generateProducerFieldBeanName(bean);
        } else if (bean.isProducerMethod()) {
            this.generateProducerMethodBeanName(bean);
        } else if (bean.isClassBean()) {
            this.generateClassBeanName(bean);
        }
    }

    private void generateProducerFieldBeanName(BeanInfo bean) {
        FieldInfo producerField = bean.getTarget().get().asField();
        ClassInfo declaringClass = producerField.declaringClass();
        Object declaringClassBase = declaringClass.enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass);
        String baseName = (String)declaringClassBase + "_ProducerField_" + producerField.name();
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateProducerMethodBeanName(BeanInfo bean) {
        MethodInfo producerMethod = bean.getTarget().get().asMethod();
        ClassInfo declaringClass = producerMethod.declaringClass();
        Object declaringClassBase = declaringClass.enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass);
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(producerMethod.name()).append("_").append(producerMethod.returnType().name().toString());
        for (org.jboss.jandex.Type i : producerMethod.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        String baseName = (String)declaringClassBase + "_ProducerMethod_" + producerMethod.name() + "_" + Hashes.sha1(sigBuilder.toString());
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateClassBeanName(BeanInfo bean) {
        ClassInfo beanClass = bean.getTarget().get().asClass();
        Object baseName = beanClass.enclosingClass() != null ? DotNames.simpleName(beanClass.enclosingClass()) + "_" + DotNames.simpleName(beanClass) : DotNames.simpleName(beanClass);
        this.beanToGeneratedBaseName.put(bean, (String)baseName);
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, (String)baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateSyntheticBeanName(BeanInfo bean) {
        StringBuilder baseNameBuilder = new StringBuilder();
        if (bean.getImplClazz().enclosingClass() != null) {
            baseNameBuilder.append(DotNames.simpleName(bean.getImplClazz().enclosingClass())).append("_").append(DotNames.simpleName(bean.getImplClazz()));
        } else {
            baseNameBuilder.append(DotNames.simpleName(bean.getImplClazz()));
        }
        baseNameBuilder.append("_");
        baseNameBuilder.append(bean.getIdentifier());
        baseNameBuilder.append("_");
        baseNameBuilder.append("Synthetic");
        String baseName = baseNameBuilder.toString();
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = bean.getTargetPackageName();
        this.beanToGeneratedName.put(bean, BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX));
    }

    Collection<ResourceOutput.Resource> generateSyntheticBean(BeanInfo bean) {
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String targetPackage = bean.getTargetPackageName();
        String baseName = this.beanToGeneratedBaseName.get(bean);
        String generatedName = this.beanToGeneratedName.get(bean);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(bean.getImplClazz().name()) || bean.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        Map<InjectionPointInfo, String> injectionPointToProviderSupplierField = Collections.emptyMap();
        if (bean.hasInjectionPoint()) {
            injectionPointToProviderSupplierField = new HashMap();
            this.initMaps(bean, injectionPointToProviderSupplierField, null, null);
            this.createProviderFields(beanCreator, bean, injectionPointToProviderSupplierField, Collections.emptyMap(), Collections.emptyMap());
        }
        MethodCreator constructor = this.initConstructor(classOutput, beanCreator, bean, injectionPointToProviderSupplierField, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        SyntheticComponentsUtil.addParamsFieldAndInit(beanCreator, constructor, bean.getParams(), this.annotationLiterals, bean.getDeployment().getBeanArchiveIndex());
        constructor.returnValue(null);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (bean.hasDestroyLogic()) {
            this.implementDestroy(bean, beanCreator, providerType, Collections.emptyMap(), isApplicationClass, baseName, targetPackage);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderSupplierField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerType, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        this.implementIsAlternative(bean, beanCreator);
        this.implementGetPriority(bean, beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetImplementationClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.SYNTHETIC);
        this.implementEquals(bean, beanCreator);
        this.implementHashCode(bean, beanCreator);
        this.implementToString(beanCreator);
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateClassBean(BeanInfo bean, ClassInfo beanClass) {
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = this.beanToGeneratedName.get(bean);
        String baseName = this.beanToGeneratedBaseName.get(bean);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(beanClass.name()) || bean.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderSupplierField = new HashMap<InjectionPointInfo, String>();
        HashMap<InterceptorInfo, String> interceptorToProviderSupplierField = new HashMap<InterceptorInfo, String>();
        HashMap<DecoratorInfo, String> decoratorToProviderSupplierField = new HashMap<DecoratorInfo, String>();
        this.initMaps(bean, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField);
        this.createProviderFields(beanCreator, bean, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField);
        this.createConstructor(classOutput, beanCreator, bean, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (bean.hasDestroyLogic()) {
            this.implementDestroy(bean, beanCreator, providerType, injectionPointToProviderSupplierField, isApplicationClass, baseName, targetPackage);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerType, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        this.implementIsAlternative(bean, beanCreator);
        this.implementGetPriority(bean, beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementIsSuppressed(bean, beanCreator);
        this.implementEquals(bean, beanCreator);
        this.implementHashCode(bean, beanCreator);
        this.implementToString(beanCreator);
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateProducerMethodBean(BeanInfo bean, MethodInfo producerMethod) {
        ClassInfo declaringClass = producerMethod.declaringClass();
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String baseName = this.beanToGeneratedBaseName.get(bean);
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = this.beanToGeneratedName.get(bean);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(declaringClass.name()) || bean.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(bean, injectionPointToProviderField, null, null);
        this.createProviderFields(beanCreator, bean, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor(classOutput, beanCreator, bean, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (bean.hasDestroyLogic()) {
            this.implementDestroy(bean, beanCreator, providerType, injectionPointToProviderField, isApplicationClass, baseName, targetPackage);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerType, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        this.implementIsAlternative(bean, beanCreator);
        this.implementGetPriority(bean, beanCreator);
        this.implementGetDeclaringBean(beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetImplementationClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.PRODUCER_METHOD);
        this.implementIsSuppressed(bean, beanCreator);
        this.implementEquals(bean, beanCreator);
        this.implementHashCode(bean, beanCreator);
        this.implementToString(beanCreator);
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateProducerFieldBean(BeanInfo bean, FieldInfo producerField) {
        ClassInfo declaringClass = producerField.declaringClass();
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String baseName = this.beanToGeneratedBaseName.get(bean);
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = this.beanToGeneratedName.get(bean);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(declaringClass.name()) || bean.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        this.createProviderFields(beanCreator, bean, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor(classOutput, beanCreator, bean, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (bean.hasDestroyLogic()) {
            this.implementDestroy(bean, beanCreator, providerType, null, isApplicationClass, baseName, targetPackage);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerType, baseName, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerType, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        this.implementIsAlternative(bean, beanCreator);
        this.implementGetPriority(bean, beanCreator);
        this.implementGetDeclaringBean(beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetImplementationClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.PRODUCER_FIELD);
        this.implementIsSuppressed(bean, beanCreator);
        this.implementEquals(bean, beanCreator);
        this.implementHashCode(bean, beanCreator);
        this.implementToString(beanCreator);
        beanCreator.close();
        return classOutput.getResources();
    }

    protected void initMaps(BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProvider, Map<InterceptorInfo, String> interceptorToProvider, Map<DecoratorInfo, String> decoratorToProvider) {
        int providerIdx = 1;
        for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
            injectionPointToProvider.put(injectionPoint, "injectProviderSupplier" + providerIdx++);
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                injectionPointToProvider.put(injectionPoint, "disposerProviderSupplier" + providerIdx++);
            }
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            interceptorToProvider.put(interceptor, "interceptorProviderSupplier" + providerIdx++);
        }
        for (DecoratorInfo decorator : bean.getBoundDecorators()) {
            decoratorToProvider.put(decorator, "decoratorProviderSupplier" + providerIdx++);
        }
    }

    protected void createProviderFields(ClassCreator beanCreator, BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProviderSupplier, Map<InterceptorInfo, String> interceptorToProviderSupplier, Map<DecoratorInfo, String> decoratorToProviderSupplier) {
        if (bean.isProducerMethod() || bean.isProducerField()) {
            beanCreator.getFieldCreator(FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, Supplier.class).setModifiers(18);
        }
        for (String provider : injectionPointToProviderSupplier.values()) {
            beanCreator.getFieldCreator(provider, Supplier.class).setModifiers(18);
        }
        for (String interceptorProvider : interceptorToProviderSupplier.values()) {
            beanCreator.getFieldCreator(interceptorProvider, Supplier.class).setModifiers(18);
        }
        for (String decoratorProvider : decoratorToProviderSupplier.values()) {
            beanCreator.getFieldCreator(decoratorProvider, Supplier.class).setModifiers(18);
        }
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, Map<DecoratorInfo, String> decoratorToProviderSupplierField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        this.initConstructor(classOutput, beanCreator, bean, injectionPointToProviderField, interceptorToProviderField, decoratorToProviderSupplierField, annotationLiterals, reflectionRegistration).returnValue(null);
    }

    protected MethodCreator initConstructor(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, Map<DecoratorInfo, String> decoratorToProviderSupplierField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        int i;
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (bean.isProducerMethod() || bean.isProducerField()) {
            parameterTypes.add(Supplier.class.getName());
        }
        for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
            if (injectionPoint.isDelegate() || BuiltinBean.resolve(injectionPoint) != null) continue;
            parameterTypes.add(Supplier.class.getName());
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                if (BuiltinBean.resolve(injectionPoint) != null) continue;
                parameterTypes.add(Supplier.class.getName());
            }
        }
        for (i = 0; i < interceptorToProviderField.size(); ++i) {
            parameterTypes.add(Supplier.class.getName());
        }
        for (i = 0; i < decoratorToProviderSupplierField.size(); ++i) {
            parameterTypes.add(Supplier.class.getName());
        }
        MethodCreator constructor = beanCreator.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        ResultHandle currentThread = constructor.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = constructor.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        int paramIdx = 0;
        if (bean.isProducerMethod() || bean.isProducerField()) {
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(0));
            ++paramIdx;
        }
        ArrayList<InjectionPointInfo> allInjectionPoints = new ArrayList<InjectionPointInfo>();
        allInjectionPoints.addAll(bean.getAllInjectionPoints());
        if (bean.getDisposer() != null) {
            allInjectionPoints.addAll(bean.getDisposer().getInjection().injectionPoints);
        }
        for (InjectionPointInfo injectionPoint : allInjectionPoints) {
            if (injectionPoint.isDelegate()) {
                ResultHandle delegateProvider = constructor.newInstance(MethodDescriptor.ofConstructor(DecoratorDelegateProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle delegateProviderSupplier = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{delegateProvider});
                constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), delegateProviderSupplier);
                continue;
            }
            if (injectionPoint.getResolvedBean() == null) {
                BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
                builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(classOutput, bean.getDeployment(), injectionPoint, beanCreator, constructor, injectionPointToProviderField.get(injectionPoint), annotationLiterals, bean, reflectionRegistration, this.injectionPointAnnotationsPredicate));
                continue;
            }
            if (injectionPoint.isCurrentInjectionPointWrapperNeeded()) {
                ResultHandle wrapHandle = this.wrapCurrentInjectionPoint(classOutput, beanCreator, bean, constructor, injectionPoint, paramIdx++, tccl, reflectionRegistration);
                ResultHandle wrapSupplierHandle = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{wrapHandle});
                constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), wrapSupplierHandle);
                continue;
            }
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderField.get(interceptor), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        for (DecoratorInfo decorator : bean.getBoundDecorators()) {
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)decoratorToProviderSupplierField.get(decorator), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        ResultHandle typesArray = constructor.newArray(Object.class, bean.getTypes().size());
        int typeIndex = 0;
        for (org.jboss.jandex.Type type : bean.getTypes()) {
            ResultHandle typeHandle;
            try {
                typeHandle = Types.getTypeHandle((BytecodeCreator)constructor, type, tccl);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to construct the type handle for " + bean + ": " + e.getMessage());
            }
            constructor.writeArrayValue(typesArray, constructor.load(typeIndex++), typeHandle);
        }
        constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_BEAN_TYPES, (String)Set.class.getName()), constructor.getThis(), constructor.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{typesArray}));
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            ResultHandle qualifiersArray = constructor.newArray(Object.class, bean.getQualifiers().size());
            int qualifierIndex = 0;
            for (AnnotationInstance qualifierAnnotation : bean.getQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    constructor.writeArrayValue(qualifiersArray, constructor.load(qualifierIndex++), qualifier.getLiteralInstance((BytecodeCreator)constructor));
                    continue;
                }
                ClassInfo qualifierClass = bean.getDeployment().getQualifier(qualifierAnnotation.name());
                constructor.writeArrayValue(qualifiersArray, constructor.load(qualifierIndex++), annotationLiterals.create((BytecodeCreator)constructor, qualifierClass, qualifierAnnotation));
            }
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_QUALIFIERS, (String)Set.class.getName()), constructor.getThis(), constructor.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{qualifiersArray}));
        }
        if (!bean.getStereotypes().isEmpty()) {
            ResultHandle stereotypesArray = constructor.newArray(Object.class, bean.getStereotypes().size());
            int stereotypesIndex = 0;
            for (StereotypeInfo stereotype : bean.getStereotypes()) {
                constructor.writeArrayValue(stereotypesArray, constructor.load(stereotypesIndex++), constructor.loadClass(stereotype.getTarget().name().toString()));
            }
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_STEREOTYPES, (String)Set.class.getName()), constructor.getThis(), constructor.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{stereotypesArray}));
        }
        return constructor;
    }

    protected void implementDestroy(BeanInfo bean, ClassCreator beanCreator, ProviderType providerType, Map<InjectionPointInfo, String> injectionPointToProviderField, boolean isApplicationClass, String baseName, String targetPackage) {
        MethodCreator destroy = (MethodCreator)beanCreator.getMethodCreator("destroy", Void.TYPE, new Object[]{providerType.descriptorName(), CreationalContext.class}).setModifiers(1);
        if (bean.isClassBean()) {
            if (!bean.isInterceptor()) {
                if (!bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty()) {
                    destroy.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)SubclassGenerator.generatedName(bean.getProviderType().name(), baseName), (String)"arc$destroy", Void.TYPE, (Object[])new Object[0]), destroy.getMethodParam(0), new ResultHandle[0]);
                }
                List<MethodInfo> preDestroyCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.PRE_DESTROY, bean.getDeployment().getBeanArchiveIndex());
                for (MethodInfo callback : preDestroyCallbacks) {
                    if (this.isReflectionFallbackNeeded(callback, targetPackage)) {
                        if (Modifier.isPrivate(callback.flags())) {
                            this.privateMembers.add(isApplicationClass, String.format("@PreDestroy callback %s#%s()", callback.declaringClass().name(), callback.name()));
                        }
                        this.reflectionRegistration.registerMethod(callback);
                        destroy.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{destroy.loadClass(callback.declaringClass().name().toString()), destroy.load(callback.name()), destroy.newArray(Class.class, destroy.load(0)), destroy.getMethodParam(0), destroy.newArray(Object.class, destroy.load(0))});
                        continue;
                    }
                    destroy.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback), destroy.getMethodParam(0), new ResultHandle[0]);
                }
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, destroy.getMethodParam(1), new ResultHandle[0]);
            destroy.returnValue(null);
        } else if (bean.getDisposer() != null) {
            ResultHandle declaringProviderInstanceHandle;
            MethodInfo disposerMethod = bean.getDisposer().getDisposerMethod();
            boolean isStatic = Modifier.isStatic(disposerMethod.flags());
            ResultHandle declaringProviderSupplierHandle = destroy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), destroy.getThis());
            ResultHandle declaringProviderHandle = destroy.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
            ResultHandle ctxHandle = destroy.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{destroy.loadNull()});
            if (isStatic) {
                declaringProviderInstanceHandle = destroy.loadNull();
            } else {
                declaringProviderInstanceHandle = destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
                if (bean.getDeclaringBean().getScope().isNormal()) {
                    declaringProviderInstanceHandle = destroy.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
                }
            }
            ResultHandle[] referenceHandles = new ResultHandle[disposerMethod.parametersCount()];
            short disposedParamPosition = bean.getDisposer().getDisposedParameter().position();
            Iterator<InjectionPointInfo> injectionPointsIterator = bean.getDisposer().getInjection().injectionPoints.iterator();
            for (int i = 0; i < disposerMethod.parametersCount(); ++i) {
                if (i == disposedParamPosition) {
                    referenceHandles[i] = destroy.getMethodParam(0);
                    continue;
                }
                InjectionPointInfo injectionPoint = injectionPointsIterator.next();
                ResultHandle childCtxHandle = destroy.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{declaringProviderHandle, ctxHandle});
                ResultHandle providerSupplierHandle = destroy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), destroy.getThis());
                ResultHandle providerHandle = destroy.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                AssignableResultHandle referenceHandle = destroy.createVariable(Object.class);
                destroy.assign(referenceHandle, destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle}));
                BeanGenerator.checkPrimitiveInjection((BytecodeCreator)destroy, injectionPoint, referenceHandle);
                referenceHandles[i] = referenceHandle;
            }
            if (Modifier.isPrivate(disposerMethod.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Disposer %s#%s", disposerMethod.declaringClass().name(), disposerMethod.name()));
                ResultHandle paramTypesArray = destroy.newArray(Class.class, destroy.load(referenceHandles.length));
                ResultHandle argsArray = destroy.newArray(Object.class, destroy.load(referenceHandles.length));
                for (int i = 0; i < referenceHandles.length; ++i) {
                    destroy.writeArrayValue(paramTypesArray, i, destroy.loadClass(disposerMethod.parameterType(i).name().toString()));
                    destroy.writeArrayValue(argsArray, i, referenceHandles[i]);
                }
                this.reflectionRegistration.registerMethod(disposerMethod);
                destroy.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{destroy.loadClass(disposerMethod.declaringClass().name().toString()), destroy.load(disposerMethod.name()), paramTypesArray, declaringProviderInstanceHandle, argsArray});
            } else if (isStatic) {
                destroy.invokeStaticMethod(MethodDescriptor.of((MethodInfo)disposerMethod), referenceHandles);
            } else {
                destroy.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)disposerMethod), declaringProviderInstanceHandle, referenceHandles);
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, ctxHandle, new ResultHandle[0]);
            if (BuiltinScope.DEPENDENT.is(bean.getDisposer().getDeclaringBean().getScope()) && !isStatic) {
                destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, destroy.getMethodParam(1), new ResultHandle[0]);
            destroy.returnValue(null);
        } else if (bean.isSynthetic()) {
            bean.getDestroyerConsumer().accept(destroy);
        }
        MethodCreator bridgeDestroy = (MethodCreator)beanCreator.getMethodCreator("destroy", Void.TYPE, new Class[]{Object.class, CreationalContext.class}).setModifiers(65);
        bridgeDestroy.returnValue(bridgeDestroy.invokeVirtualMethod(destroy.getMethodDescriptor(), bridgeDestroy.getThis(), new ResultHandle[]{bridgeDestroy.getMethodParam(0), bridgeDestroy.getMethodParam(1)}));
    }

    protected void implementCreate(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, Map<DecoratorInfo, String> decoratorToProviderSupplierField, String targetPackage, boolean isApplicationClass) {
        MethodCreator doCreate = (MethodCreator)beanCreator.getMethodCreator("doCreate", (Object)providerType.descriptorName(), new Object[]{CreationalContext.class}).setModifiers(2);
        if (bean.isClassBean()) {
            this.implementCreateForClassBean(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, this.reflectionRegistration, targetPackage, isApplicationClass, doCreate);
        } else if (bean.isProducerMethod()) {
            this.implementCreateForProducerMethod(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderSupplierField, this.reflectionRegistration, targetPackage, isApplicationClass, doCreate);
        } else if (bean.isProducerField()) {
            this.implementCreateForProducerField(classOutput, beanCreator, bean, providerType, baseName, injectionPointToProviderSupplierField, this.reflectionRegistration, targetPackage, isApplicationClass, doCreate);
        } else if (bean.isSynthetic()) {
            this.implementCreateForSyntheticBean(beanCreator, bean, providerType, injectionPointToProviderSupplierField, doCreate);
        }
        MethodCreator create = (MethodCreator)beanCreator.getMethodCreator("create", (Object)providerType.descriptorName(), new Object[]{CreationalContext.class}).setModifiers(1);
        TryBlock tryBlock = create.tryBlock();
        tryBlock.returnValue(tryBlock.invokeSpecialMethod(doCreate.getMethodDescriptor(), tryBlock.getThis(), new ResultHandle[]{tryBlock.getMethodParam(0)}));
        CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
        catchBlock.ifFalse(catchBlock.instanceOf(catchBlock.getCaughtException(), RuntimeException.class)).falseBranch().throwException(catchBlock.getCaughtException());
        ResultHandle creationException = catchBlock.newInstance(MethodDescriptor.ofConstructor(CreationException.class, (Class[])new Class[]{Throwable.class}), new ResultHandle[]{catchBlock.getCaughtException()});
        catchBlock.throwException(creationException);
        MethodCreator bridgeCreate = (MethodCreator)beanCreator.getMethodCreator("create", Object.class, new Class[]{CreationalContext.class}).setModifiers(65);
        bridgeCreate.returnValue(bridgeCreate.invokeVirtualMethod(create.getMethodDescriptor(), bridgeCreate.getThis(), new ResultHandle[]{bridgeCreate.getMethodParam(0)}));
    }

    private void implementCreateForSyntheticBean(ClassCreator beanCreator, BeanInfo bean, ProviderType providerType, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, MethodCreator doCreate) {
        TryBlock tryBlock;
        ResultHandle injectedReferences;
        MethodCreator createSynthetic = (MethodCreator)beanCreator.getMethodCreator("createSynthetic", (Object)providerType.descriptorName(), new Object[]{SyntheticCreationalContext.class}).setModifiers(2);
        bean.getCreatorConsumer().accept(createSynthetic);
        if (injectionPointToProviderSupplierField.isEmpty()) {
            injectedReferences = doCreate.invokeStaticMethod(MethodDescriptors.COLLECTIONS_EMPTY_MAP, new ResultHandle[0]);
        } else {
            injectedReferences = doCreate.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle tccl = doCreate.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, doCreate.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]), new ResultHandle[0]);
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                ResultHandle qualifiersArray;
                ResultHandle requiredType;
                tryBlock = doCreate.tryBlock();
                try {
                    requiredType = Types.getTypeHandle((BytecodeCreator)tryBlock, injectionPoint.getType(), tccl);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to construct the type handle for " + injectionPoint.getType() + ": " + e.getMessage());
                }
                if (injectionPoint.hasDefaultedQualifier()) {
                    qualifiersArray = tryBlock.loadNull();
                } else {
                    qualifiersArray = tryBlock.newArray(Annotation.class, injectionPoint.getRequiredQualifiers().size());
                    int qualifierIndex = 0;
                    for (AnnotationInstance qualifierAnnotation : injectionPoint.getRequiredQualifiers()) {
                        BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                        if (qualifier != null) {
                            tryBlock.writeArrayValue(qualifiersArray, tryBlock.load(qualifierIndex++), qualifier.getLiteralInstance((BytecodeCreator)tryBlock));
                            continue;
                        }
                        ClassInfo qualifierClass = bean.getDeployment().getQualifier(qualifierAnnotation.name());
                        tryBlock.writeArrayValue(qualifiersArray, tryBlock.load(qualifierIndex++), this.annotationLiterals.create((BytecodeCreator)tryBlock, qualifierClass, qualifierAnnotation));
                    }
                }
                ResultHandle typeAndQualifiers = tryBlock.newInstance(MethodDescriptor.ofConstructor(SyntheticCreationalContextImpl.TypeAndQualifiers.class, (Class[])new Class[]{Type.class, Annotation[].class}), new ResultHandle[]{requiredType, qualifiersArray});
                ResultHandle providerSupplierHandle = tryBlock.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), tryBlock.getThis());
                ResultHandle providerHandle = tryBlock.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtxHandle = tryBlock.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, tryBlock.getMethodParam(0)});
                AssignableResultHandle injectedReference = tryBlock.createVariable(Object.class);
                tryBlock.assign(injectedReference, tryBlock.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle}));
                BeanGenerator.checkPrimitiveInjection((BytecodeCreator)tryBlock, injectionPoint, injectedReference);
                tryBlock.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, injectedReferences, new ResultHandle[]{typeAndQualifiers, injectedReference});
                CatchBlockCreator catchBlock = tryBlock.addCatch(RuntimeException.class);
                catchBlock.throwException(RuntimeException.class, "Error injecting synthetic injection point of bean: " + bean.getIdentifier(), catchBlock.getCaughtException());
            }
        }
        ResultHandle paramsHandle = doCreate.readInstanceField(FieldDescriptor.of((String)doCreate.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), doCreate.getThis());
        ResultHandle syntheticCreationalContext = doCreate.newInstance(MethodDescriptor.ofConstructor(SyntheticCreationalContextImpl.class, (Class[])new Class[]{CreationalContext.class, Map.class, Map.class}), new ResultHandle[]{doCreate.getMethodParam(0), paramsHandle, injectedReferences});
        AssignableResultHandle ret = doCreate.createVariable(providerType.descriptorName());
        tryBlock = doCreate.tryBlock();
        tryBlock.assign(ret, tryBlock.invokeVirtualMethod(createSynthetic.getMethodDescriptor(), tryBlock.getThis(), new ResultHandle[]{syntheticCreationalContext}));
        CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
        Gizmo.StringBuilderGenerator strBuilder = Gizmo.newStringBuilder((BytecodeCreator)catchBlock);
        strBuilder.append("Error creating synthetic bean [");
        strBuilder.append(bean.getIdentifier());
        strBuilder.append("]: ");
        strBuilder.append(Gizmo.toString((BytecodeCreator)catchBlock, (ResultHandle)catchBlock.getCaughtException()));
        ResultHandle exception = catchBlock.newInstance(MethodDescriptor.ofConstructor(CreationException.class, (Class[])new Class[]{String.class, Throwable.class}), new ResultHandle[]{strBuilder.callToString(), catchBlock.getCaughtException()});
        catchBlock.throwException(exception);
        if (bean.getScope().isNormal()) {
            BytecodeCreator nullBeanInstance = doCreate.ifNull((ResultHandle)ret).trueBranch();
            Gizmo.StringBuilderGenerator message = Gizmo.newStringBuilder((BytecodeCreator)nullBeanInstance);
            message.append("Null contextual instance was produced by a normal scoped synthetic bean: ");
            message.append(Gizmo.toString((BytecodeCreator)nullBeanInstance, (ResultHandle)nullBeanInstance.getThis()));
            ResultHandle e = nullBeanInstance.newInstance(MethodDescriptor.ofConstructor(CreationException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{message.callToString()});
            nullBeanInstance.throwException(e);
        }
        doCreate.returnValue((ResultHandle)ret);
    }

    private void newProviderHandles(BeanInfo bean, ClassCreator beanCreator, MethodCreator createMethod, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, Map<DecoratorInfo, String> decoratorToProviderSupplierField, Map<InterceptorInfo, ResultHandle> interceptorToWrap, List<TransientReference> transientReferences, List<ResultHandle> injectableParamHandles, List<ResultHandle> allOtherParamHandles) {
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        if (constructorInjection.isPresent()) {
            for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                ResultHandle providerSupplierHandle = createMethod.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), createMethod.getThis());
                ResultHandle providerHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtx = createMethod.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, createMethod.getMethodParam(0)});
                AssignableResultHandle referenceHandle = createMethod.createVariable(Object.class);
                createMethod.assign(referenceHandle, createMethod.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtx}));
                BeanGenerator.checkPrimitiveInjection((BytecodeCreator)createMethod, injectionPoint, referenceHandle);
                injectableParamHandles.add((ResultHandle)referenceHandle);
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference(providerHandle, (ResultHandle)referenceHandle, childCtx));
            }
        }
        if (bean.isSubclassRequired()) {
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                ResultHandle wrapped = interceptorToWrap.get(interceptor);
                if (wrapped != null) {
                    allOtherParamHandles.add(wrapped);
                    continue;
                }
                ResultHandle interceptorProviderSupplierHandle = createMethod.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderField.get(interceptor), Supplier.class), createMethod.getThis());
                ResultHandle interceptorProviderHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorProviderSupplierHandle, new ResultHandle[0]);
                allOtherParamHandles.add(interceptorProviderHandle);
            }
            for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                ResultHandle decoratorProviderSupplierHandle = createMethod.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)decoratorToProviderSupplierField.get(decorator), Supplier.class), createMethod.getThis());
                ResultHandle decoratorProviderHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, decoratorProviderSupplierHandle, new ResultHandle[0]);
                allOtherParamHandles.add(decoratorProviderHandle);
            }
        }
    }

    static void checkPrimitiveInjection(BytecodeCreator bytecode, InjectionPointInfo injectionPoint, AssignableResultHandle referenceHandle) {
        if (injectionPoint.getType().kind() == Type.Kind.PRIMITIVE) {
            org.jboss.jandex.Type type = null;
            if (injectionPoint.getResolvedBean().isProducerField()) {
                type = injectionPoint.getResolvedBean().getTarget().get().asField().type();
            } else if (injectionPoint.getResolvedBean().isProducerMethod()) {
                type = injectionPoint.getResolvedBean().getTarget().get().asMethod().returnType();
            }
            if (type != null && Types.isPrimitiveWrapperType(type)) {
                BytecodeCreator isNull = bytecode.ifNull((ResultHandle)referenceHandle).trueBranch();
                isNull.assign(referenceHandle, Types.loadPrimitiveDefault(injectionPoint.getType().asPrimitiveType().primitive(), isNull));
            }
        }
    }

    private ResultHandle newInstanceHandle(BeanInfo bean, ClassCreator beanCreator, BytecodeCreator creator, MethodCreator createMethod, String providerTypeName, String baseName, List<ResultHandle> providerHandles, ReflectionRegistration registration, boolean isApplicationClass) {
        List injectionPoints;
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        MethodInfo constructor = constructorInjection.isPresent() ? constructorInjection.get().target.asMethod() : null;
        List<Object> list = injectionPoints = constructorInjection.isPresent() ? constructorInjection.get().injectionPoints : Collections.emptyList();
        if (bean.isSubclassRequired()) {
            int i;
            List<InterceptorInfo> interceptors = bean.getBoundInterceptors();
            List<DecoratorInfo> decorators = bean.getBoundDecorators();
            ArrayList<String> paramTypes = new ArrayList<String>();
            ArrayList<ResultHandle> paramHandles = new ArrayList<ResultHandle>();
            for (i = 0; i < injectionPoints.size(); ++i) {
                paramTypes.add(((InjectionPointInfo)injectionPoints.get(i)).getType().name().toString());
                paramHandles.add(providerHandles.get(i));
            }
            paramHandles.add(createMethod.getMethodParam(0));
            paramTypes.add(CreationalContext.class.getName());
            for (i = 0; i < interceptors.size(); ++i) {
                paramTypes.add(InjectableInterceptor.class.getName());
                paramHandles.add(providerHandles.get(injectionPoints.size() + i));
            }
            for (i = 0; i < decorators.size(); ++i) {
                paramTypes.add(InjectableDecorator.class.getName());
                paramHandles.add(providerHandles.get(injectionPoints.size() + interceptors.size() + i));
            }
            return creator.newInstance(MethodDescriptor.ofConstructor((String)SubclassGenerator.generatedName(bean.getProviderType().name(), baseName), (String[])paramTypes.toArray(new String[0])), paramHandles.toArray(new ResultHandle[0]));
        }
        if (constructorInjection.isPresent()) {
            if (Modifier.isPrivate(constructor.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", constructor, constructor.declaringClass().name()));
                ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(providerHandles.size()));
                ResultHandle argsArray = creator.newArray(Object.class, creator.load(providerHandles.size()));
                for (int i = 0; i < injectionPoints.size(); ++i) {
                    creator.writeArrayValue(paramTypesArray, i, creator.loadClass(((InjectionPointInfo)injectionPoints.get(i)).getType().name().toString()));
                    creator.writeArrayValue(argsArray, i, providerHandles.get(i));
                }
                registration.registerMethod(constructor);
                return creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_NEW_INSTANCE, new ResultHandle[]{creator.loadClass(constructor.declaringClass().name().toString()), paramTypesArray, argsArray});
            }
            String[] paramTypes = new String[injectionPoints.size()];
            ListIterator iterator = injectionPoints.listIterator();
            while (iterator.hasNext()) {
                InjectionPointInfo injectionPoint = (InjectionPointInfo)iterator.next();
                paramTypes[iterator.previousIndex()] = DescriptorUtils.typeToString((org.jboss.jandex.Type)injectionPoint.getType());
            }
            return creator.newInstance(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])paramTypes), providerHandles.toArray(new ResultHandle[0]));
        }
        MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
        if (Modifier.isPrivate(noArgsConstructor.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", noArgsConstructor, noArgsConstructor.declaringClass().name()));
            ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(0));
            ResultHandle argsArray = creator.newArray(Object.class, creator.load(0));
            registration.registerMethod(noArgsConstructor);
            return creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_NEW_INSTANCE, new ResultHandle[]{creator.loadClass(noArgsConstructor.declaringClass().name().toString()), paramTypesArray, argsArray});
        }
        return creator.newInstance(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])new String[0]), new ResultHandle[0]);
    }

    void implementCreateForProducerField(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        ResultHandle declaringProviderInstanceHandle;
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerType.className()));
        FieldInfo producerField = bean.getTarget().get().asField();
        ResultHandle declaringProviderSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), create.getThis());
        ResultHandle declaringProviderHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        ResultHandle ctxHandle = create.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{create.getThis()});
        if (Modifier.isStatic(producerField.flags())) {
            declaringProviderInstanceHandle = create.loadNull();
        } else {
            declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
            if (bean.getDeclaringBean().getScope().isNormal()) {
                declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
            }
        }
        if (Modifier.isPrivate(producerField.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Producer field %s#%s", producerField.declaringClass().name(), producerField.name()));
            reflectionRegistration.registerField(producerField);
            create.assign(instanceHandle, create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_READ_FIELD, new ResultHandle[]{create.loadClass(producerField.declaringClass().name().toString()), create.load(producerField.name()), declaringProviderInstanceHandle}));
        } else {
            ResultHandle readFieldHandle = Modifier.isStatic(producerField.flags()) ? create.readStaticField(FieldDescriptor.of((FieldInfo)producerField)) : create.readInstanceField(FieldDescriptor.of((FieldInfo)producerField), declaringProviderInstanceHandle);
            create.assign(instanceHandle, readFieldHandle);
        }
        if (bean.getScope().isNormal()) {
            create.ifNull((ResultHandle)instanceHandle).trueBranch().throwException(IllegalProductException.class, "Normal scoped producer field may not be null: " + bean.getDeclaringBean().getImplClazz().name() + "." + bean.getTarget().get().asField().name());
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope())) {
            create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
        }
        create.returnValue((ResultHandle)instanceHandle);
    }

    void implementCreateForProducerMethod(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        ResultHandle declaringProviderInstanceHandle;
        MethodInfo producerMethod = bean.getTarget().get().asMethod();
        boolean isStatic = Modifier.isStatic(producerMethod.flags());
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerType.className()));
        ResultHandle ctxHandle = create.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{create.getThis()});
        ResultHandle declaringProviderSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), create.getThis());
        ResultHandle declaringProviderHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        if (isStatic) {
            declaringProviderInstanceHandle = create.loadNull();
        } else {
            declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
            if (bean.getDeclaringBean().getScope().isNormal()) {
                declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
            }
        }
        List<InjectionPointInfo> injectionPoints = bean.getAllInjectionPoints();
        ResultHandle[] referenceHandles = new ResultHandle[injectionPoints.size()];
        ArrayList<TransientReference> transientReferences = new ArrayList<TransientReference>();
        int paramIdx = 0;
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            ResultHandle providerSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), create.getThis());
            ResultHandle providerHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
            ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, create.getMethodParam(0)});
            AssignableResultHandle referenceHandle = create.createVariable(Object.class);
            create.assign(referenceHandle, create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle}));
            BeanGenerator.checkPrimitiveInjection((BytecodeCreator)create, injectionPoint, referenceHandle);
            referenceHandles[paramIdx++] = referenceHandle;
            if (!injectionPoint.isDependentTransientReference()) continue;
            transientReferences.add(new TransientReference(providerHandle, (ResultHandle)referenceHandle, childCtxHandle));
        }
        if (Modifier.isPrivate(producerMethod.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Producer method %s#%s()", producerMethod.declaringClass().name(), producerMethod.name()));
            ResultHandle paramTypesArray = create.newArray(Class.class, create.load(referenceHandles.length));
            ResultHandle argsArray = create.newArray(Object.class, create.load(referenceHandles.length));
            for (int i = 0; i < referenceHandles.length; ++i) {
                create.writeArrayValue(paramTypesArray, i, create.loadClass(producerMethod.parameterType(i).name().toString()));
                create.writeArrayValue(argsArray, i, referenceHandles[i]);
            }
            reflectionRegistration.registerMethod(producerMethod);
            create.assign(instanceHandle, create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(producerMethod.declaringClass().name().toString()), create.load(producerMethod.name()), paramTypesArray, declaringProviderInstanceHandle, argsArray}));
        } else {
            ResultHandle invokeMethodHandle = isStatic ? create.invokeStaticMethod(MethodDescriptor.of((MethodInfo)producerMethod), referenceHandles) : create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)producerMethod), declaringProviderInstanceHandle, referenceHandles);
            create.assign(instanceHandle, invokeMethodHandle);
        }
        if (bean.getScope().isNormal()) {
            create.ifNull((ResultHandle)instanceHandle).trueBranch().throwException(IllegalProductException.class, "Normal scoped producer method may not return null: " + bean.getDeclaringBean().getImplClazz().name() + "." + bean.getTarget().get().asMethod().name() + "()");
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope()) && !isStatic) {
            create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
        }
        BeanGenerator.destroyTransientReferences((BytecodeCreator)create, transientReferences);
        create.returnValue((ResultHandle)instanceHandle);
    }

    void implementCreateForClassBean(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, Map<DecoratorInfo, String> decoratorToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        BeanInfo.InterceptionInfo postConstructs;
        ArrayList<TransientReference> transientReferences;
        ResultHandle postConstructsHandle = null;
        ResultHandle aroundConstructsHandle = null;
        HashMap<InterceptorInfo, ResultHandle> interceptorToWrap = new HashMap<InterceptorInfo, ResultHandle>();
        if (bean.hasLifecycleInterceptors()) {
            ResultHandle interceptorInvocationHandle;
            ResultHandle interceptorHandle;
            ResultHandle interceptorSupplierHandle;
            BeanInfo.InterceptionInfo postConstructs2 = bean.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT);
            BeanInfo.InterceptionInfo aroundConstructs = bean.getLifecycleInterceptors(InterceptionType.AROUND_CONSTRUCT);
            HashSet<InterceptorInfo> wraps = new HashSet<InterceptorInfo>();
            wraps.addAll(aroundConstructs.interceptors);
            wraps.addAll(postConstructs2.interceptors);
            HashMap<InterceptorInfo, ResultHandle> interceptorToResultHandle = new HashMap<InterceptorInfo, ResultHandle>();
            for (InterceptorInfo interceptor : wraps) {
                ResultHandle interceptorProviderSupplier = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                ResultHandle interceptorProvider = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorProviderSupplier, new ResultHandle[0]);
                ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{create.getMethodParam(0)});
                ResultHandle interceptorInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, interceptorProvider, new ResultHandle[]{childCtxHandle});
                interceptorToResultHandle.put(interceptor, interceptorInstanceHandle);
                ResultHandle wrapHandle = create.invokeStaticMethod(MethodDescriptor.ofMethod(InitializedInterceptor.class, (String)"of", InitializedInterceptor.class, (Class[])new Class[]{Object.class, InjectableInterceptor.class}), new ResultHandle[]{interceptorInstanceHandle, interceptorProvider});
                interceptorToWrap.put(interceptor, wrapHandle);
            }
            if (!postConstructs2.isEmpty()) {
                postConstructsHandle = create.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (InterceptorInfo interceptor : postConstructs2.interceptors) {
                    interceptorSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                    interceptorHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorSupplierHandle, new ResultHandle[0]);
                    interceptorInvocationHandle = create.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_POST_CONSTRUCT, new ResultHandle[]{interceptorHandle, (ResultHandle)interceptorToResultHandle.get(interceptor)});
                    create.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, postConstructsHandle, new ResultHandle[]{interceptorInvocationHandle});
                }
            }
            if (!aroundConstructs.isEmpty()) {
                aroundConstructsHandle = create.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (InterceptorInfo interceptor : aroundConstructs.interceptors) {
                    interceptorSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                    interceptorHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorSupplierHandle, new ResultHandle[0]);
                    interceptorInvocationHandle = create.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_CONSTRUCT, new ResultHandle[]{interceptorHandle, (ResultHandle)interceptorToResultHandle.get(interceptor)});
                    create.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, aroundConstructsHandle, new ResultHandle[]{interceptorInvocationHandle});
                }
            }
        }
        BeanInfo.InterceptionInfo aroundConstructs = bean.getLifecycleInterceptors(InterceptionType.AROUND_CONSTRUCT);
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerType.className()));
        if (!aroundConstructs.isEmpty()) {
            ResultHandle constructorHandle;
            Optional<Injection> constructorInjection = bean.getConstructorInjection();
            if (constructorInjection.isPresent()) {
                ArrayList<String> paramTypes = new ArrayList<String>();
                for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                    paramTypes.add(injectionPoint.getType().name().toString());
                }
                ResultHandle[] paramsHandles = new ResultHandle[2];
                paramsHandles[0] = create.loadClass(providerType.className());
                ResultHandle paramsArray = create.newArray(Class.class, create.load(paramTypes.size()));
                ListIterator iterator = paramTypes.listIterator();
                while (iterator.hasNext()) {
                    create.writeArrayValue(paramsArray, iterator.nextIndex(), create.loadClass((String)iterator.next()));
                }
                paramsHandles[1] = paramsArray;
                constructorHandle = create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
                reflectionRegistration.registerMethod(constructorInjection.get().target.asMethod());
            } else {
                ResultHandle[] paramsHandles = new ResultHandle[]{create.loadClass(providerType.className()), create.newArray(Class.class, create.load(0))};
                constructorHandle = create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
                MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
                reflectionRegistration.registerMethod(noArgsConstructor);
            }
            transientReferences = new ArrayList<TransientReference>();
            ArrayList<ResultHandle> injectableCtorParams = new ArrayList<ResultHandle>();
            ArrayList<ResultHandle> allOtherCtorParams = new ArrayList<ResultHandle>();
            this.newProviderHandles(bean, beanCreator, create, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, interceptorToWrap, transientReferences, injectableCtorParams, allOtherCtorParams);
            FunctionCreator func = create.createFunction(Supplier.class);
            BytecodeCreator funcBytecode = func.getBytecode();
            ArrayList<ResultHandle> providerHandles = new ArrayList<ResultHandle>(injectableCtorParams);
            providerHandles.addAll(allOtherCtorParams);
            ResultHandle retHandle = this.newInstanceHandle(bean, beanCreator, funcBytecode, create, providerType.className(), baseName, providerHandles, reflectionRegistration, isApplicationClass);
            BeanGenerator.destroyTransientReferences(funcBytecode, transientReferences);
            funcBytecode.returnValue(retHandle);
            ResultHandle bindingsArray = create.newArray(Object.class, aroundConstructs.bindings.size());
            int bindingsIndex = 0;
            for (AnnotationInstance binding : aroundConstructs.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                create.writeArrayValue(bindingsArray, bindingsIndex++, this.annotationLiterals.create((BytecodeCreator)create, bindingClass, binding));
            }
            ResultHandle ctorArgsArray = create.newArray(Object.class, create.load(injectableCtorParams.size()));
            for (int i = 0; i < injectableCtorParams.size(); ++i) {
                create.writeArrayValue(ctorArgsArray, i, (ResultHandle)injectableCtorParams.get(i));
            }
            ResultHandle invocationContextHandle = create.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_AROUND_CONSTRUCT, new ResultHandle[]{constructorHandle, ctorArgsArray, aroundConstructsHandle, func.getInstance(), create.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{bindingsArray})});
            TryBlock tryCatch = create.tryBlock();
            CatchBlockCreator exceptionCatch = tryCatch.addCatch(Exception.class);
            exceptionCatch.throwException(RuntimeException.class, "Error invoking aroundConstructs", exceptionCatch.getCaughtException());
            tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_PROCEED, invocationContextHandle, new ResultHandle[0]);
            tryCatch.assign(instanceHandle, tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_GET_TARGET, invocationContextHandle, new ResultHandle[0]));
        } else {
            ArrayList<TransientReference> transientReferences2 = new ArrayList<TransientReference>();
            ArrayList<ResultHandle> providerHandles = new ArrayList<ResultHandle>();
            this.newProviderHandles(bean, beanCreator, create, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, interceptorToWrap, transientReferences2, providerHandles, providerHandles);
            create.assign(instanceHandle, this.newInstanceHandle(bean, beanCreator, (BytecodeCreator)create, create, providerType.className(), baseName, providerHandles, reflectionRegistration, isApplicationClass));
            BeanGenerator.destroyTransientReferences((BytecodeCreator)create, transientReferences2);
        }
        for (Injection injection : bean.getInjections()) {
            if (injection.isField()) {
                TryBlock tryBlock = create.tryBlock();
                InjectionPointInfo injectionPoint = injection.injectionPoints.get(0);
                ResultHandle providerSupplierHandle = tryBlock.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), tryBlock.getThis());
                ResultHandle providerHandle = tryBlock.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtxHandle = tryBlock.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, tryBlock.getMethodParam(0)});
                AssignableResultHandle referenceHandle = tryBlock.createVariable(Object.class);
                tryBlock.assign(referenceHandle, tryBlock.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle}));
                BeanGenerator.checkPrimitiveInjection((BytecodeCreator)tryBlock, injectionPoint, referenceHandle);
                FieldInfo injectedField = injection.target.asField();
                if (this.isReflectionFallbackNeeded(injectedField, targetPackage, bean)) {
                    if (Modifier.isPrivate(injectedField.flags())) {
                        this.privateMembers.add(isApplicationClass, String.format("@Inject field %s#%s", injection.target.asField().declaringClass().name(), injection.target.asField().name()));
                    }
                    reflectionRegistration.registerField(injectedField);
                    tryBlock.invokeStaticMethod(MethodDescriptors.REFLECTIONS_WRITE_FIELD, new ResultHandle[]{tryBlock.loadClass(injectedField.declaringClass().name().toString()), tryBlock.load(injectedField.name()), instanceHandle, referenceHandle});
                } else {
                    tryBlock.writeInstanceField(FieldDescriptor.of((String)injectedField.declaringClass().name().toString(), (String)injectedField.name(), (String)DescriptorUtils.typeToString((org.jboss.jandex.Type)injectionPoint.getTarget().asField().type())), (ResultHandle)instanceHandle, (ResultHandle)referenceHandle);
                }
                CatchBlockCreator catchBlock = tryBlock.addCatch(RuntimeException.class);
                catchBlock.throwException(RuntimeException.class, "Error injecting " + injection.target, catchBlock.getCaughtException());
                continue;
            }
            if (!injection.isMethod() || injection.isConstructor()) continue;
            transientReferences = new ArrayList();
            ResultHandle[] referenceHandles = new ResultHandle[injection.injectionPoints.size()];
            int paramIdx = 0;
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                ResultHandle providerSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), create.getThis());
                ResultHandle providerHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, create.getMethodParam(0)});
                AssignableResultHandle referenceHandle = create.createVariable(Object.class);
                create.assign(referenceHandle, create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle}));
                BeanGenerator.checkPrimitiveInjection((BytecodeCreator)create, injectionPoint, referenceHandle);
                referenceHandles[paramIdx++] = referenceHandle;
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference(providerHandle, (ResultHandle)referenceHandle, childCtxHandle));
            }
            MethodInfo initializerMethod = injection.target.asMethod();
            if (this.isReflectionFallbackNeeded(initializerMethod, targetPackage)) {
                if (Modifier.isPrivate(initializerMethod.flags())) {
                    this.privateMembers.add(isApplicationClass, String.format("@Inject initializer %s#%s()", initializerMethod.declaringClass().name(), initializerMethod.name()));
                }
                ResultHandle paramTypesArray = create.newArray(Class.class, create.load(referenceHandles.length));
                ResultHandle argsArray = create.newArray(Object.class, create.load(referenceHandles.length));
                for (int i = 0; i < referenceHandles.length; ++i) {
                    create.writeArrayValue(paramTypesArray, i, create.loadClass(initializerMethod.parameterType(i).name().toString()));
                    create.writeArrayValue(argsArray, i, (ResultHandle)referenceHandles[i]);
                }
                reflectionRegistration.registerMethod(initializerMethod);
                create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(initializerMethod.declaringClass().name().toString()), create.load(injection.target.asMethod().name()), paramTypesArray, instanceHandle, argsArray});
            } else {
                create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)injection.target.asMethod()), (ResultHandle)instanceHandle, referenceHandles);
            }
            BeanGenerator.destroyTransientReferences((BytecodeCreator)create, transientReferences);
        }
        if (bean.isSubclassRequired()) {
            String subclassName = SubclassGenerator.generatedName(bean.getProviderType().name(), baseName);
            create.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)subclassName, (String)"arc$markConstructed", Void.TYPE, (Object[])new Object[0]), (ResultHandle)instanceHandle, new ResultHandle[0]);
        }
        if (!(postConstructs = bean.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT)).isEmpty()) {
            ResultHandle bindingsArray = create.newArray(Object.class, postConstructs.bindings.size());
            int bindingsIndex = 0;
            for (AnnotationInstance binding : postConstructs.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                create.writeArrayValue(bindingsArray, bindingsIndex++, this.annotationLiterals.create((BytecodeCreator)create, bindingClass, binding));
            }
            ResultHandle invocationContextHandle = create.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_POST_CONSTRUCT, new ResultHandle[]{instanceHandle, postConstructsHandle, create.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{bindingsArray})});
            TryBlock tryCatch = create.tryBlock();
            CatchBlockCreator exceptionCatch = tryCatch.addCatch(Exception.class);
            exceptionCatch.throwException(RuntimeException.class, "Error invoking postConstructs", exceptionCatch.getCaughtException());
            tryCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"proceed", Object.class, (Class[])new Class[0]), invocationContextHandle, new ResultHandle[0]);
        }
        if (!bean.isInterceptor()) {
            List<MethodInfo> postConstructCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.POST_CONSTRUCT, bean.getDeployment().getBeanArchiveIndex());
            for (MethodInfo callback : postConstructCallbacks) {
                if (this.isReflectionFallbackNeeded(callback, targetPackage)) {
                    if (Modifier.isPrivate(callback.flags())) {
                        this.privateMembers.add(isApplicationClass, String.format("@PostConstruct callback %s#%s()", callback.declaringClass().name(), callback.name()));
                    }
                    reflectionRegistration.registerMethod(callback);
                    create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(callback.declaringClass().name().toString()), create.load(callback.name()), create.newArray(Class.class, create.load(0)), instanceHandle, create.newArray(Object.class, create.load(0))});
                    continue;
                }
                create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback), (ResultHandle)instanceHandle, new ResultHandle[0]);
            }
        }
        create.returnValue((ResultHandle)instanceHandle);
    }

    protected void implementGet(BeanInfo bean, ClassCreator beanCreator, ProviderType providerType, String baseName) {
        MethodCreator get = (MethodCreator)beanCreator.getMethodCreator("get", (Object)providerType.descriptorName(), new Object[]{CreationalContext.class}).setModifiers(1);
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            ResultHandle instance = get.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)beanCreator.getClassName(), (String)"create", (Object)providerType.descriptorName(), (Object[])new Object[]{CreationalContext.class}), get.getThis(), new ResultHandle[]{get.getMethodParam(0)});
            if (!bean.hasDestroyLogic()) {
                ResultHandle creationalContext = get.checkCast(get.getMethodParam(0), CreationalContextImpl.class);
                get.ifNonZero(get.invokeVirtualMethod(MethodDescriptors.CREATIONAL_CTX_HAS_DEPENDENT_INSTANCES, creationalContext, new ResultHandle[0])).falseBranch().returnValue(instance);
            }
            get.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_ADD_DEP_TO_PARENT, new ResultHandle[]{get.getThis(), instance, get.getMethodParam(0)});
            get.returnValue(instance);
        } else if (bean.getScope().isNormal()) {
            get.returnValue(get.invokeVirtualMethod(MethodDescriptor.ofMethod((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)this.getProxyTypeName(bean, baseName), (String[])new String[0]), get.getThis(), new ResultHandle[0]));
        } else {
            ResultHandle container = get.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle creationalContext = get.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{get.getThis()});
            ResultHandle scope = get.loadClass(bean.getScope().getDotName().toString());
            ResultHandle context = get.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
            get.returnValue(get.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET, context, new ResultHandle[]{get.getThis(), creationalContext}));
        }
        MethodCreator bridgeGet = (MethodCreator)beanCreator.getMethodCreator("get", Object.class, new Class[]{CreationalContext.class}).setModifiers(65);
        bridgeGet.returnValue(bridgeGet.invokeVirtualMethod(get.getMethodDescriptor(), bridgeGet.getThis(), new ResultHandle[]{bridgeGet.getMethodParam(0)}));
    }

    protected void implementGetTypes(ClassCreator beanCreator, FieldDescriptor typesField) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getTypes", Set.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.readInstanceField(typesField, getScope.getThis()));
    }

    protected void implementGetScope(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getScope", Class.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.loadClass(bean.getScope().getDotName().toString()));
    }

    protected void implementGetIdentifier(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getIdentifier", String.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.load(bean.getIdentifier()));
    }

    protected void implementEquals(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator equals = (MethodCreator)beanCreator.getMethodCreator("equals", Boolean.TYPE, new Class[]{Object.class}).setModifiers(1);
        ResultHandle obj = equals.getMethodParam(0);
        equals.ifReferencesEqual(equals.getThis(), obj).trueBranch().returnValue(equals.load(true));
        equals.ifNull(obj).trueBranch().returnValue(equals.load(false));
        equals.ifFalse(equals.instanceOf(obj, InjectableBean.class)).trueBranch().returnValue(equals.load(false));
        ResultHandle injectableBean = equals.checkCast(obj, InjectableBean.class);
        ResultHandle otherIdentifier = equals.invokeInterfaceMethod(MethodDescriptors.GET_IDENTIFIER, injectableBean, new ResultHandle[0]);
        equals.returnValue(equals.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, equals.load(bean.getIdentifier()), new ResultHandle[]{otherIdentifier}));
    }

    protected void implementHashCode(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator hashCode = (MethodCreator)beanCreator.getMethodCreator("hashCode", Integer.TYPE, new Class[0]).setModifiers(1);
        ResultHandle constantHashCodeResult = hashCode.load(bean.getIdentifier().hashCode());
        hashCode.returnValue(constantHashCodeResult);
    }

    protected void implementToString(ClassCreator beanCreator) {
        MethodCreator toString = (MethodCreator)beanCreator.getMethodCreator("toString", String.class, new Class[0]).setModifiers(1);
        toString.returnValue(toString.invokeStaticMethod(MethodDescriptors.BEANS_TO_STRING, new ResultHandle[]{toString.getThis()}));
    }

    protected void implementGetQualifiers(BeanInfo bean, ClassCreator beanCreator, FieldDescriptor qualifiersField) {
        MethodCreator getQualifiers = (MethodCreator)beanCreator.getMethodCreator("getQualifiers", Set.class, new Class[0]).setModifiers(1);
        getQualifiers.returnValue(getQualifiers.readInstanceField(qualifiersField, getQualifiers.getThis()));
    }

    protected void implementGetDeclaringBean(ClassCreator beanCreator) {
        MethodCreator getDeclaringBean = (MethodCreator)beanCreator.getMethodCreator("getDeclaringBean", InjectableBean.class, new Class[0]).setModifiers(1);
        ResultHandle declaringProviderSupplierHandle = getDeclaringBean.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), getDeclaringBean.getThis());
        getDeclaringBean.returnValue(getDeclaringBean.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]));
    }

    protected void implementIsAlternative(BeanInfo bean, ClassCreator beanCreator) {
        if (bean.isAlternative()) {
            MethodCreator isAlternative = (MethodCreator)beanCreator.getMethodCreator("isAlternative", Boolean.TYPE, new Class[0]).setModifiers(1);
            isAlternative.returnValue(isAlternative.load(true));
        }
    }

    protected void implementGetPriority(BeanInfo bean, ClassCreator beanCreator) {
        if (bean.getPriority() != null) {
            MethodCreator getPriority = (MethodCreator)beanCreator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
            getPriority.returnValue(getPriority.load(bean.getPriority().intValue()));
        }
    }

    protected void implementIsDefaultBean(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator isDefaultBean = (MethodCreator)beanCreator.getMethodCreator("isDefaultBean", Boolean.TYPE, new Class[0]).setModifiers(1);
        isDefaultBean.returnValue(isDefaultBean.load(bean.isDefaultBean()));
    }

    protected void implementGetStereotypes(BeanInfo bean, ClassCreator beanCreator, FieldDescriptor stereotypesField) {
        MethodCreator getStereotypes = (MethodCreator)beanCreator.getMethodCreator("getStereotypes", Set.class, new Class[0]).setModifiers(1);
        getStereotypes.returnValue(getStereotypes.readInstanceField(stereotypesField, getStereotypes.getThis()));
    }

    protected void implementGetBeanClass(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getBeanClass = (MethodCreator)beanCreator.getMethodCreator("getBeanClass", Class.class, new Class[0]).setModifiers(1);
        getBeanClass.returnValue(getBeanClass.loadClass(bean.getBeanClass().toString()));
    }

    protected void implementGetImplementationClass(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getImplementationClass = (MethodCreator)beanCreator.getMethodCreator("getImplementationClass", Class.class, new Class[0]).setModifiers(1);
        getImplementationClass.returnValue(bean.getImplClazz() != null ? getImplementationClass.loadClass(bean.getImplClazz()) : getImplementationClass.loadNull());
    }

    protected void implementGetName(BeanInfo bean, ClassCreator beanCreator) {
        if (bean.getName() != null) {
            MethodCreator getName = (MethodCreator)beanCreator.getMethodCreator("getName", String.class, new Class[0]).setModifiers(1);
            getName.returnValue(getName.load(bean.getName()));
        }
    }

    protected void implementGetKind(ClassCreator beanCreator, InjectableBean.Kind kind) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getKind", InjectableBean.Kind.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.readStaticField(FieldDescriptor.of(InjectableBean.Kind.class, (String)kind.toString(), InjectableBean.Kind.class)));
    }

    protected void implementSupplierGet(ClassCreator beanCreator) {
        MethodCreator get = (MethodCreator)beanCreator.getMethodCreator("get", Object.class, new Class[0]).setModifiers(1);
        get.returnValue(get.getThis());
    }

    protected void implementIsSuppressed(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator isSuppressed = (MethodCreator)beanCreator.getMethodCreator("isSuppressed", Boolean.TYPE, new Class[0]).setModifiers(1);
        for (Function<BeanInfo, Consumer<BytecodeCreator>> generator : this.suppressConditionGenerators) {
            Consumer<BytecodeCreator> condition = generator.apply(bean);
            if (condition == null) continue;
            condition.accept((BytecodeCreator)isSuppressed);
        }
        isSuppressed.returnValue(isSuppressed.load(false));
    }

    private String getProxyTypeName(BeanInfo bean, String baseName) {
        StringBuilder proxyTypeName = new StringBuilder();
        proxyTypeName.append(bean.getClientProxyPackageName());
        if (proxyTypeName.length() > 0) {
            proxyTypeName.append(".");
        }
        proxyTypeName.append(baseName);
        proxyTypeName.append("_ClientProxy");
        return proxyTypeName.toString();
    }

    private ResultHandle wrapCurrentInjectionPoint(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, MethodCreator constructor, InjectionPointInfo injectionPoint, int paramIdx, ResultHandle tccl, ReflectionRegistration reflectionRegistration) {
        ResultHandle requiredQualifiersHandle = BeanGenerator.collectInjectionPointQualifiers(classOutput, beanCreator, bean.getDeployment(), constructor, injectionPoint, this.annotationLiterals);
        ResultHandle annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(classOutput, beanCreator, bean.getDeployment(), constructor, injectionPoint, this.annotationLiterals, this.injectionPointAnnotationsPredicate);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(constructor, injectionPoint, reflectionRegistration);
        boolean isTransient = injectionPoint.isField() && Modifier.isTransient(injectionPoint.getTarget().asField().flags());
        return constructor.newInstance(MethodDescriptor.ofConstructor(CurrentInjectionPointProvider.class, (Class[])new Class[]{InjectableBean.class, Supplier.class, Type.class, Set.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE}), new ResultHandle[]{constructor.getThis(), constructor.getMethodParam(paramIdx), Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getType(), tccl), requiredQualifiersHandle, annotationsHandle, javaMemberHandle, constructor.load(injectionPoint.getPosition()), constructor.load(isTransient)});
    }

    private void initializeProxy(BeanInfo bean, String baseName, ClassCreator beanCreator) {
        String proxyTypeName = this.getProxyTypeName(bean, baseName);
        beanCreator.getFieldCreator(FIELD_NAME_PROXY, proxyTypeName).setModifiers(66);
        MethodCreator proxy = (MethodCreator)beanCreator.getMethodCreator(FIELD_NAME_PROXY, proxyTypeName, new String[0]).setModifiers(2);
        AssignableResultHandle proxyInstance = proxy.createVariable(DescriptorUtils.extToInt((String)proxyTypeName));
        proxy.assign(proxyInstance, proxy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)proxyTypeName), proxy.getThis()));
        BytecodeCreator proxyNull = proxy.ifNull((ResultHandle)proxyInstance).trueBranch();
        proxyNull.assign(proxyInstance, proxyNull.newInstance(MethodDescriptor.ofConstructor((Object)proxyTypeName, (Object[])new Object[]{String.class}), new ResultHandle[]{proxyNull.load(bean.getIdentifier())}));
        proxyNull.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)proxyTypeName), proxyNull.getThis(), (ResultHandle)proxyInstance);
        proxy.returnValue((ResultHandle)proxyInstance);
    }

    public static ResultHandle getJavaMemberHandle(MethodCreator constructor, InjectionPointInfo injectionPoint, ReflectionRegistration reflectionRegistration) {
        ResultHandle javaMemberHandle;
        if (injectionPoint.isSynthetic()) {
            javaMemberHandle = constructor.loadNull();
        } else if (injectionPoint.isField()) {
            FieldInfo field = injectionPoint.getTarget().asField();
            javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_FIELD, new ResultHandle[]{constructor.loadClass(field.declaringClass().name().toString()), constructor.load(field.name())});
            reflectionRegistration.registerField(field);
        } else {
            MethodInfo method = injectionPoint.getTarget().asMethod();
            reflectionRegistration.registerMethod(method);
            if (method.name().equals("<init>")) {
                ResultHandle[] paramsHandles = new ResultHandle[2];
                paramsHandles[0] = constructor.loadClass(method.declaringClass().name().toString());
                ResultHandle paramsArray = constructor.newArray(Class.class, constructor.load(method.parametersCount()));
                ListIterator iterator = method.parameterTypes().listIterator();
                while (iterator.hasNext()) {
                    constructor.writeArrayValue(paramsArray, iterator.nextIndex(), constructor.loadClass(((org.jboss.jandex.Type)iterator.next()).name().toString()));
                }
                paramsHandles[1] = paramsArray;
                javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
            } else {
                ResultHandle[] paramsHandles = new ResultHandle[3];
                paramsHandles[0] = constructor.loadClass(method.declaringClass().name().toString());
                paramsHandles[1] = constructor.load(method.name());
                ResultHandle paramsArray = constructor.newArray(Class.class, constructor.load(method.parametersCount()));
                ListIterator iterator = method.parameterTypes().listIterator();
                while (iterator.hasNext()) {
                    constructor.writeArrayValue(paramsArray, iterator.nextIndex(), constructor.loadClass(((org.jboss.jandex.Type)iterator.next()).name().toString()));
                }
                paramsHandles[2] = paramsArray;
                javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
            }
        }
        return javaMemberHandle;
    }

    public static ResultHandle collectInjectionPointAnnotations(ClassOutput classOutput, ClassCreator beanCreator, BeanDeployment beanDeployment, MethodCreator constructor, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> injectionPointAnnotationsPredicate) {
        Collection<AnnotationInstance> annotations;
        if (injectionPoint.isSynthetic()) {
            return constructor.invokeStaticMethod(MethodDescriptors.COLLECTIONS_EMPTY_SET, new ResultHandle[0]);
        }
        ResultHandle annotationsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (AnnotationTarget.Kind.FIELD.equals((Object)injectionPoint.getTarget().kind())) {
            FieldInfo field = injectionPoint.getTarget().asField();
            annotations = beanDeployment.getAnnotations((AnnotationTarget)field);
        } else {
            MethodInfo method = injectionPoint.getTarget().asMethod();
            annotations = Annotations.getParameterAnnotations(beanDeployment, method, injectionPoint.getPosition());
        }
        for (AnnotationInstance annotation : annotations) {
            ResultHandle annotationHandle;
            if (!injectionPointAnnotationsPredicate.test(annotation.name())) continue;
            if (DotNames.INJECT.equals((Object)annotation.name())) {
                annotationHandle = constructor.readStaticField(FieldDescriptor.of(InjectLiteral.class, (String)"INSTANCE", InjectLiteral.class));
            } else {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), annotation.name());
                if (annotationClass == null) continue;
                annotationHandle = annotationLiterals.create((BytecodeCreator)constructor, annotationClass, annotation);
            }
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotationsHandle, new ResultHandle[]{annotationHandle});
        }
        return annotationsHandle;
    }

    public static ResultHandle collectInjectionPointQualifiers(ClassOutput classOutput, ClassCreator beanCreator, BeanDeployment beanDeployment, MethodCreator constructor, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals) {
        return BeanGenerator.collectQualifiers(classOutput, beanCreator, beanDeployment, constructor, annotationLiterals, injectionPoint.hasDefaultedQualifier() ? Collections.emptySet() : injectionPoint.getRequiredQualifiers());
    }

    public static ResultHandle collectQualifiers(ClassOutput classOutput, ClassCreator beanCreator, BeanDeployment beanDeployment, MethodCreator constructor, AnnotationLiteralProcessor annotationLiterals, Set<AnnotationInstance> requiredQualifiers) {
        ResultHandle requiredQualifiersHandle;
        if (requiredQualifiers.isEmpty()) {
            requiredQualifiersHandle = constructor.readStaticField(FieldDescriptors.QUALIFIERS_IP_QUALIFIERS);
        } else {
            requiredQualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance qualifierAnnotation : requiredQualifiers) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                ResultHandle qualifierHandle = qualifier != null ? qualifier.getLiteralInstance((BytecodeCreator)constructor) : annotationLiterals.create((BytecodeCreator)constructor, beanDeployment.getQualifier(qualifierAnnotation.name()), qualifierAnnotation);
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, requiredQualifiersHandle, new ResultHandle[]{qualifierHandle});
            }
        }
        return requiredQualifiersHandle;
    }

    static void destroyTransientReferences(BytecodeCreator bytecode, Iterable<TransientReference> transientReferences) {
        for (TransientReference transientReference : transientReferences) {
            bytecode.invokeStaticMethod(MethodDescriptors.INJECTABLE_REFERENCE_PROVIDERS_DESTROY, new ResultHandle[]{transientReference.provider, transientReference.instance, transientReference.creationalContext});
        }
    }

    static final class ProviderType {
        private final org.jboss.jandex.Type type;

        public ProviderType(org.jboss.jandex.Type type) {
            this.type = type;
        }

        DotName name() {
            return this.type.name();
        }

        String className() {
            return this.type.name().toString();
        }

        String descriptorName() {
            return DescriptorUtils.typeToString((org.jboss.jandex.Type)this.type);
        }
    }

    static class TransientReference {
        final ResultHandle provider;
        final ResultHandle instance;
        final ResultHandle creationalContext;

        public TransientReference(ResultHandle provider, ResultHandle contextualInstance, ResultHandle creationalContext) {
            this.provider = provider;
            this.instance = contextualInstance;
            this.creationalContext = creationalContext;
        }
    }
}

