/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class AsmUtilCopy {
    private static final Function<TypeVariable, Type> NO_ARG_MAPPER = new Function<TypeVariable, Type>(){

        @Override
        public Type apply(TypeVariable t) {
            return null;
        }
    };

    public static String getSignature(MethodInfo method) {
        return AsmUtilCopy.getSignature(method, NO_ARG_MAPPER);
    }

    public static String getSignature(MethodInfo method, Function<TypeVariable, Type> typeArgMapper) {
        List parameters = method.parameters();
        StringBuilder signature = new StringBuilder("");
        AsmUtilCopy.toSignature(signature, method.typeParameters(), typeArgMapper, false);
        signature.append("(");
        for (Type type : parameters) {
            AsmUtilCopy.toSignature(signature, type, typeArgMapper, false);
        }
        signature.append(")");
        AsmUtilCopy.toSignature(signature, method.returnType(), typeArgMapper, false);
        return signature.toString();
    }

    private static void toSignature(StringBuilder sb, Type type, Function<TypeVariable, Type> typeArgMapper, boolean erased) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    sb.append("[");
                }
                AsmUtilCopy.toSignature(sb, arrayType.component(), typeArgMapper, erased);
                break;
            }
            case CLASS: {
                sb.append("L");
                sb.append(type.asClassType().name().toString().replace('.', '/'));
                sb.append(";");
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                sb.append("L");
                sb.append(parameterizedType.name().toString().replace('.', '/'));
                if (!erased && !parameterizedType.arguments().isEmpty()) {
                    sb.append("<");
                    List arguments = parameterizedType.arguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Type argType = (Type)arguments.get(i);
                        AsmUtilCopy.toSignature(sb, argType, typeArgMapper, erased);
                    }
                    sb.append(">");
                }
                sb.append(";");
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        sb.append('Z');
                        break;
                    }
                    case BYTE: {
                        sb.append('B');
                        break;
                    }
                    case CHAR: {
                        sb.append('C');
                        break;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break;
                    }
                    case INT: {
                        sb.append('I');
                        break;
                    }
                    case LONG: {
                        sb.append('J');
                        break;
                    }
                    case SHORT: {
                        sb.append('S');
                    }
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = type.asTypeVariable();
                Type mappedType = typeArgMapper.apply(typeVariable);
                if (mappedType != null) {
                    AsmUtilCopy.toSignature(sb, mappedType, typeArgMapper, erased);
                    break;
                }
                if (erased) {
                    AsmUtilCopy.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, erased);
                    break;
                }
                sb.append("T").append(typeVariable.identifier()).append(";");
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                break;
            }
            case VOID: {
                sb.append("V");
                break;
            }
            case WILDCARD_TYPE: {
                if (erased) break;
                sb.append("*");
                break;
            }
        }
    }

    public static String getGeneratedSubClassSignature(ClassInfo superClass, Type superClassAsType) {
        StringBuilder signature = new StringBuilder();
        AsmUtilCopy.toSignature(signature, superClass.typeParameters(), NO_ARG_MAPPER, false);
        AsmUtilCopy.toSignature(signature, superClassAsType, NO_ARG_MAPPER, false);
        return signature.toString();
    }

    private static void toSignature(StringBuilder sb, List<TypeVariable> typeParameters, Function<TypeVariable, Type> typeArgMapper, boolean b) {
        for (TypeVariable typeVariable : typeParameters) {
            if (sb.length() == 0) {
                sb.append("<");
            } else {
                sb.append(",");
            }
            sb.append(typeVariable.identifier()).append(":");
            AsmUtilCopy.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, false);
        }
        if (sb.length() > 0) {
            sb.append(">");
        }
    }

    public static boolean needsSignature(MethodInfo method) {
        if (!method.typeParameters().isEmpty() || AsmUtilCopy.needsSignature(method.returnType())) {
            return true;
        }
        for (Type type : method.parameters()) {
            if (!AsmUtilCopy.needsSignature(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsSignature(Type type) {
        if (type == null) {
            return false;
        }
        switch (type.kind()) {
            default: {
                return false;
            }
            case PARAMETERIZED_TYPE: 
            case TYPE_VARIABLE: 
            case UNRESOLVED_TYPE_VARIABLE: 
            case WILDCARD_TYPE: 
        }
        return true;
    }
}

