/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.itext.openpdf.deployment;

import com.lowagie.bouncycastle.BouncyCastleHelper;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.internal.PdfVersionImp;
import io.quarkiverse.itext.openpdf.runtime.OpenPDFFeature;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class OpenPDFProcessor {
    private static final String FEATURE = "openpdf";

    OpenPDFProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(OpenPDFFeature.class);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("com.github.librepdf", FEATURE));
    }

    @BuildStep
    NativeImageEnableAllCharsetsBuildItem enableAllCharsetsBuildItem() {
        return new NativeImageEnableAllCharsetsBuildItem();
    }

    @BuildStep
    void registerOpenPdfFonts(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("**/pdf/fonts/**");
        builder.includeGlob("font-fallback/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    @BuildStep
    void registerOpenPdfResources(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("com/lowagie/text/error_messages/en.lng"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("com/lowagie/text/error_messages/nl.lng"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("com/lowagie/text/error_messages/pt.lng"));
    }

    @BuildStep
    void registerOpenPdfForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>(this.collectSubclasses(combinedIndex, Image.class.getName()));
        classNames.add(BouncyCastleHelper.class.getName());
        classNames.add(PageSize.class.getName());
        classNames.add(Utilities.class.getName());
        classNames.add(PdfName.class.getName());
        classNames.add(PdfVersionImp.class.getName());
        Log.debugf((String)"OpenPDF Reflection: %s", classNames);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods().fields().build());
    }

    @BuildStep(onlyIf={IsNormal.class})
    void uberJarServiceLoaders(BuildProducer<UberJarMergedResourceBuildItem> producer) {
        producer.produce((BuildItem)new UberJarMergedResourceBuildItem("META-INF/versions/9/OSGI-INF/MANIFEST.MF"));
    }

    public List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }
}

