/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.GetMilestonesFiltersParameter;
import io.qase.client.model.HashResponse;
import io.qase.client.model.SharedStepCreate;
import io.qase.client.model.SharedStepListResponse;
import io.qase.client.model.SharedStepResponse;
import io.qase.client.model.SharedStepUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SharedStepsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SharedStepsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SharedStepsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSharedStepCall(String code, SharedStepCreate sharedStepCreate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SharedStepCreate localVarPostBody = sharedStepCreate;
        String localVarPath = "/shared_step/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSharedStepValidateBeforeCall(String code, SharedStepCreate sharedStepCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createSharedStep(Async)");
        }
        if (sharedStepCreate == null) {
            throw new QaseException("Missing the required parameter 'sharedStepCreate' when calling createSharedStep(Async)");
        }
        return this.createSharedStepCall(code, sharedStepCreate, _callback);
    }

    public HashResponse createSharedStep(String code, SharedStepCreate sharedStepCreate) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.createSharedStepWithHttpInfo(code, sharedStepCreate);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> createSharedStepWithHttpInfo(String code, SharedStepCreate sharedStepCreate) throws QaseException {
        Call localVarCall = this.createSharedStepValidateBeforeCall(code, sharedStepCreate, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSharedStepAsync(String code, SharedStepCreate sharedStepCreate, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.createSharedStepValidateBeforeCall(code, sharedStepCreate, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSharedStepCall(String code, String hash, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}/{hash}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{hash}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSharedStepValidateBeforeCall(String code, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling deleteSharedStep(Async)");
        }
        return this.deleteSharedStepCall(code, hash, _callback);
    }

    public HashResponse deleteSharedStep(String code, String hash) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.deleteSharedStepWithHttpInfo(code, hash);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> deleteSharedStepWithHttpInfo(String code, String hash) throws QaseException {
        Call localVarCall = this.deleteSharedStepValidateBeforeCall(code, hash, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSharedStepAsync(String code, String hash, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteSharedStepValidateBeforeCall(code, hash, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedStepCall(String code, String hash, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}/{hash}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{hash}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedStepValidateBeforeCall(String code, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling getSharedStep(Async)");
        }
        return this.getSharedStepCall(code, hash, _callback);
    }

    public SharedStepResponse getSharedStep(String code, String hash) throws QaseException {
        ApiResponse<SharedStepResponse> localVarResp = this.getSharedStepWithHttpInfo(code, hash);
        return localVarResp.getData();
    }

    public ApiResponse<SharedStepResponse> getSharedStepWithHttpInfo(String code, String hash) throws QaseException {
        Call localVarCall = this.getSharedStepValidateBeforeCall(code, hash, null);
        Type localVarReturnType = new TypeToken<SharedStepResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedStepAsync(String code, String hash, ApiCallback<SharedStepResponse> _callback) throws QaseException {
        Call localVarCall = this.getSharedStepValidateBeforeCall(code, hash, _callback);
        Type localVarReturnType = new TypeToken<SharedStepResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedStepsCall(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedStepsValidateBeforeCall(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSharedSteps(Async)");
        }
        return this.getSharedStepsCall(code, filters, limit, offset, _callback);
    }

    public SharedStepListResponse getSharedSteps(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<SharedStepListResponse> localVarResp = this.getSharedStepsWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<SharedStepListResponse> getSharedStepsWithHttpInfo(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getSharedStepsValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<SharedStepListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedStepsAsync(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, ApiCallback<SharedStepListResponse> _callback) throws QaseException {
        Call localVarCall = this.getSharedStepsValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<SharedStepListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSharedStepCall(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SharedStepUpdate localVarPostBody = sharedStepUpdate;
        String localVarPath = "/shared_step/{code}/{hash}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{hash}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSharedStepValidateBeforeCall(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling updateSharedStep(Async)");
        }
        if (sharedStepUpdate == null) {
            throw new QaseException("Missing the required parameter 'sharedStepUpdate' when calling updateSharedStep(Async)");
        }
        return this.updateSharedStepCall(code, hash, sharedStepUpdate, _callback);
    }

    public HashResponse updateSharedStep(String code, String hash, SharedStepUpdate sharedStepUpdate) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.updateSharedStepWithHttpInfo(code, hash, sharedStepUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> updateSharedStepWithHttpInfo(String code, String hash, SharedStepUpdate sharedStepUpdate) throws QaseException {
        Call localVarCall = this.updateSharedStepValidateBeforeCall(code, hash, sharedStepUpdate, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSharedStepAsync(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.updateSharedStepValidateBeforeCall(code, hash, sharedStepUpdate, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

