/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.GetCasesFiltersParameter;
import io.qase.client.model.IdResponse;
import io.qase.client.model.TestCaseCreate;
import io.qase.client.model.TestCaseListResponse;
import io.qase.client.model.TestCaseResponse;
import io.qase.client.model.TestCaseUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CasesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CasesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CasesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCaseCall(String code, TestCaseCreate testCaseCreate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TestCaseCreate localVarPostBody = testCaseCreate;
        String localVarPath = "/case/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCaseValidateBeforeCall(String code, TestCaseCreate testCaseCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createCase(Async)");
        }
        if (testCaseCreate == null) {
            throw new QaseException("Missing the required parameter 'testCaseCreate' when calling createCase(Async)");
        }
        return this.createCaseCall(code, testCaseCreate, _callback);
    }

    public IdResponse createCase(String code, TestCaseCreate testCaseCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createCaseWithHttpInfo(code, testCaseCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createCaseWithHttpInfo(String code, TestCaseCreate testCaseCreate) throws QaseException {
        Call localVarCall = this.createCaseValidateBeforeCall(code, testCaseCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCaseAsync(String code, TestCaseCreate testCaseCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createCaseValidateBeforeCall(code, testCaseCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCaseCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/case/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCaseValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteCase(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteCase(Async)");
        }
        return this.deleteCaseCall(code, id, _callback);
    }

    public IdResponse deleteCase(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deleteCaseWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteCaseWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.deleteCaseValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCaseAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteCaseValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCaseCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/case/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCaseValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getCase(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getCase(Async)");
        }
        return this.getCaseCall(code, id, _callback);
    }

    public TestCaseResponse getCase(String code, Integer id) throws QaseException {
        ApiResponse<TestCaseResponse> localVarResp = this.getCaseWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<TestCaseResponse> getCaseWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.getCaseValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<TestCaseResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCaseAsync(String code, Integer id, ApiCallback<TestCaseResponse> _callback) throws QaseException {
        Call localVarCall = this.getCaseValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<TestCaseResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCasesCall(String code, GetCasesFiltersParameter filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/case/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCasesValidateBeforeCall(String code, GetCasesFiltersParameter filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getCases(Async)");
        }
        return this.getCasesCall(code, filters, limit, offset, _callback);
    }

    public TestCaseListResponse getCases(String code, GetCasesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<TestCaseListResponse> localVarResp = this.getCasesWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<TestCaseListResponse> getCasesWithHttpInfo(String code, GetCasesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getCasesValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<TestCaseListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCasesAsync(String code, GetCasesFiltersParameter filters, Integer limit, Integer offset, ApiCallback<TestCaseListResponse> _callback) throws QaseException {
        Call localVarCall = this.getCasesValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<TestCaseListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCaseCall(String code, Integer id, TestCaseUpdate testCaseUpdate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TestCaseUpdate localVarPostBody = testCaseUpdate;
        String localVarPath = "/case/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCaseValidateBeforeCall(String code, Integer id, TestCaseUpdate testCaseUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateCase(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateCase(Async)");
        }
        if (testCaseUpdate == null) {
            throw new QaseException("Missing the required parameter 'testCaseUpdate' when calling updateCase(Async)");
        }
        return this.updateCaseCall(code, id, testCaseUpdate, _callback);
    }

    public IdResponse updateCase(String code, Integer id, TestCaseUpdate testCaseUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.updateCaseWithHttpInfo(code, id, testCaseUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updateCaseWithHttpInfo(String code, Integer id, TestCaseUpdate testCaseUpdate) throws QaseException {
        Call localVarCall = this.updateCaseValidateBeforeCall(code, id, testCaseUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCaseAsync(String code, Integer id, TestCaseUpdate testCaseUpdate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.updateCaseValidateBeforeCall(code, id, testCaseUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

