/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api;

import io.qase.client.model.ResultCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CasesStorage {
    private static final Logger log = LoggerFactory.getLogger(CasesStorage.class);
    private static final ThreadLocal<ResultCreate> CURRENT_CASE = new ThreadLocal();

    public static void startCase(ResultCreate resultCreate) {
        CasesStorage.checkCaseIsNotInProgress();
        CURRENT_CASE.set(resultCreate);
    }

    public static void stopCase() {
        CasesStorage.checkCaseIsInProgress();
        CURRENT_CASE.remove();
    }

    public static ResultCreate getCurrentCase() {
        CasesStorage.checkCaseIsInProgress();
        return CURRENT_CASE.get();
    }

    public static boolean isCaseInProgress() {
        return CURRENT_CASE.get() != null;
    }

    private static void checkCaseIsInProgress() {
        if (!CasesStorage.isCaseInProgress()) {
            log.error("A case has not been started yet.");
        }
    }

    private static void checkCaseIsNotInProgress() {
        if (CasesStorage.isCaseInProgress()) {
            log.error("Previous case is still in progress.");
        }
    }
}

