/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit5assert;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AllureJunit5Assert {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunit5Assert.class);
    private StepResult stepResult;
    private static InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    @Pointcut(value="call(void org.junit.jupiter.api.Assertions.*(..)) || throwable()")
    public void anyAssert() {
    }

    @Pointcut(value="call(Throwable org.junit.jupiter.api.Assertions.*(..))")
    public void throwable() {
    }

    @Before(value="anyAssert()")
    public void stepStart(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length > 1) {
            String name;
            String uuid = UUID.randomUUID().toString();
            String assertName = joinPoint.getSignature().getName();
            if (joinPoint.getSignature().getName().equalsIgnoreCase("assertAll")) {
                name = String.format("assert All in  '%s'", joinPoint.getArgs()[0].toString());
            } else {
                String actual = joinPoint.getArgs().length > 0 ? ObjectUtils.toString((Object)joinPoint.getArgs()[1]) : "<?>";
                String expected = joinPoint.getArgs().length > 0 ? ObjectUtils.toString((Object)joinPoint.getArgs()[0]) : "<?>";
                List<String> assertArray = Arrays.asList(assertName.split("(?=[A-Z])"));
                name = assertArray.size() >= 3 ? String.format(assertArray.get(0) + " " + assertArray.get(1) + " '%s'", expected) + " " + String.format(assertArray.stream().skip(2L).collect(Collectors.joining(" ")) + " '%s'", actual) : String.format(assertArray.get(0) + " '%s'", expected) + " " + String.format(assertArray.get(1) + " '%s'", actual);
            }
            StepResult result = new StepResult().setName(name).setStatus(Status.PASSED);
            AllureJunit5Assert.getLifecycle().startStep(uuid, result);
        } else if (joinPoint.getArgs().length > 0) {
            String actual = joinPoint.getArgs().length > 0 ? ObjectUtils.toString((Object)joinPoint.getArgs()[0]) : "<?>";
            String uuid = UUID.randomUUID().toString();
            String assertName = joinPoint.getSignature().getName();
            String name = String.format(assertName + " '%s'", actual);
            StepResult result = new StepResult().setName(name).setStatus(Status.PASSED);
            AllureJunit5Assert.getLifecycle().startStep(uuid, result);
        }
    }

    @AfterThrowing(pointcut="anyAssert()", throwing="e")
    public void stepFailed(Throwable e) {
        AllureJunit5Assert.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)));
        AllureJunit5Assert.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="anyAssert()")
    public void stepStop() {
        AllureJunit5Assert.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        AllureJunit5Assert.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }
}

