/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Step;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.AspectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.List;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class StepsAspects {
    private static InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    @Pointcut(value="@annotation(io.qameta.allure.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step step = methodSignature.getMethod().getAnnotation(Step.class);
        String uuid = UUID.randomUUID().toString();
        String name = AspectUtils.getName(step.value(), methodSignature, joinPoint.getArgs());
        List<Parameter> parameters = AspectUtils.getParameters(methodSignature, joinPoint.getArgs());
        StepResult result = new StepResult().setName(name).setParameters(parameters);
        StepsAspects.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(Throwable e) {
        StepsAspects.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus(e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(e).orElse(null)));
        StepsAspects.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="anyMethod() && withStepAnnotation()")
    public void stepStop() {
        StepsAspects.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        StepsAspects.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }
}

