/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Attachment;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class AttachmentsAspects {
    private static AllureLifecycle lifecycle;

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }

    public static void setLifecycle(AllureLifecycle lifecycle) {
        AttachmentsAspects.lifecycle = lifecycle;
    }

    @Pointcut(value="@annotation(io.qameta.allure.Attachment)")
    public void withAttachmentAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @AfterReturning(pointcut="anyMethod() && withAttachmentAnnotation()", returning="result")
    public void attachment(JoinPoint joinPoint, Object result) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Attachment attachment = methodSignature.getMethod().getAnnotation(Attachment.class);
        byte[] bytes = result instanceof byte[] ? (byte[])result : result.toString().getBytes(StandardCharsets.UTF_8);
        AttachmentsAspects.getLifecycle().addAttachment(attachment.value(), attachment.type(), attachment.fileExtension(), bytes);
    }
}

