/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.FileSystemResultsWriter;
import io.qameta.allure.internal.AllureStorage;
import io.qameta.allure.listener.ContainerLifecycleListener;
import io.qameta.allure.listener.FixtureLifecycleListener;
import io.qameta.allure.listener.LifecycleNotifier;
import io.qameta.allure.listener.StepLifecycleListener;
import io.qameta.allure.listener.TestLifecycleListener;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.model.WithAttachments;
import io.qameta.allure.util.ServiceLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureLifecycle.class);
    private final AllureResultsWriter writer;
    private final AllureStorage storage;
    private final LifecycleNotifier notifier;

    public AllureLifecycle() {
        this((AllureResultsWriter)AllureLifecycle.getDefaultWriter());
    }

    public AllureLifecycle(AllureResultsWriter writer) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.notifier = new LifecycleNotifier(ServiceLoaderUtils.load(ContainerLifecycleListener.class, classLoader), ServiceLoaderUtils.load(TestLifecycleListener.class, classLoader), ServiceLoaderUtils.load(FixtureLifecycleListener.class, classLoader), ServiceLoaderUtils.load(StepLifecycleListener.class, classLoader));
        this.writer = writer;
        this.storage = new AllureStorage();
    }

    public void startTestContainer(String parentUuid, TestResultContainer container) {
        this.updateTestContainer(parentUuid, found -> found.getChildren().add(container.getUuid()));
        this.startTestContainer(container);
    }

    public void startTestContainer(TestResultContainer container) {
        this.notifier.beforeContainerStart(container);
        container.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.addContainer(container);
        this.notifier.afterContainerStart(container);
    }

    public void updateTestContainer(String uuid, Consumer<TestResultContainer> update) {
        TestResultContainer container = this.storage.getContainer(uuid);
        this.notifier.beforeContainerUpdate(container);
        update.accept(container);
        this.notifier.afterContainerUpdate(container);
    }

    public void stopTestContainer(String uuid) {
        TestResultContainer container = this.storage.getContainer(uuid);
        this.notifier.beforeContainerStop(container);
        container.setStop(Long.valueOf(System.currentTimeMillis()));
        this.notifier.afterContainerUpdate(container);
    }

    public void writeTestContainer(String uuid) {
        TestResultContainer container = this.storage.removeContainer(uuid);
        this.notifier.beforeContainerWrite(container);
        this.writer.write(container);
        this.notifier.afterContainerWrite(container);
    }

    public void startPrepareFixture(String parentUuid, String uuid, FixtureResult result) {
        this.notifier.beforeFixtureStart(result);
        this.updateTestContainer(parentUuid, container -> container.getBefores().add(result));
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    public void startTearDownFixture(String parentUuid, String uuid, FixtureResult result) {
        this.notifier.beforeFixtureStart(result);
        this.updateTestContainer(parentUuid, container -> container.getAfters().add(result));
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    private void startFixture(String uuid, FixtureResult result) {
        this.storage.addFixture(uuid, result);
        result.setStage(Stage.RUNNING);
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.clearStepContext();
        this.storage.startStep(uuid);
    }

    public void updateFixture(Consumer<FixtureResult> update) {
        this.updateFixture(this.storage.getRootStep(), update);
    }

    public void updateFixture(String uuid, Consumer<FixtureResult> update) {
        FixtureResult fixture = this.storage.getFixture(uuid);
        this.notifier.beforeFixtureUpdate(fixture);
        update.accept(fixture);
        this.notifier.afterFixtureUpdate(fixture);
    }

    public void stopFixture(String uuid) {
        FixtureResult fixture = this.storage.removeFixture(uuid);
        this.notifier.beforeFixtureStop(fixture);
        this.storage.clearStepContext();
        fixture.setStage(Stage.FINISHED);
        fixture.setStop(Long.valueOf(System.currentTimeMillis()));
        this.notifier.afterFixtureStop(fixture);
    }

    public void scheduleTestCase(String parentUuid, TestResult result) {
        this.updateTestContainer(parentUuid, container -> container.getChildren().add(result.getUuid()));
        this.scheduleTestCase(result);
    }

    public void scheduleTestCase(TestResult result) {
        this.notifier.beforeTestSchedule(result);
        result.setStage(Stage.SCHEDULED);
        this.storage.addTestResult(result);
        this.notifier.afterTestSchedule(result);
    }

    public void startTestCase(String uuid) {
        TestResult testResult = this.storage.getTestResult(uuid);
        this.notifier.beforeTestStart(testResult);
        testResult.withStage(Stage.RUNNING).withStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.clearStepContext();
        this.storage.startStep(uuid);
        this.notifier.afterTestStart(testResult);
    }

    public void updateTestCase(Consumer<TestResult> update) {
        String uuid = this.storage.getRootStep();
        this.updateTestCase(uuid, update);
    }

    public void updateTestCase(String uuid, Consumer<TestResult> update) {
        TestResult testResult = this.storage.getTestResult(uuid);
        this.notifier.beforeTestUpdate(testResult);
        update.accept(testResult);
        this.notifier.afterTestUpdate(testResult);
    }

    public void stopTestCase(String uuid) {
        TestResult testResult = this.storage.getTestResult(uuid);
        this.notifier.beforeTestStop(testResult);
        testResult.withStage(Stage.FINISHED).withStop(Long.valueOf(System.currentTimeMillis()));
        this.storage.clearStepContext();
        this.notifier.afterTestStop(testResult);
    }

    public void writeTestCase(String uuid) {
        TestResult testResult = this.storage.removeTestResult(uuid);
        this.notifier.beforeTestWrite(testResult);
        this.writer.write(testResult);
        this.notifier.afterTestWrite(testResult);
    }

    public void startStep(String uuid, StepResult result) {
        this.startStep(this.storage.getCurrentStep(), uuid, result);
    }

    public void startStep(String parentUuid, String uuid, StepResult result) {
        this.notifier.beforeStepStart(result);
        result.setStage(Stage.RUNNING);
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.startStep(uuid);
        this.storage.addStep(parentUuid, uuid, result);
        this.notifier.afterStepStart(result);
    }

    public void updateStep(Consumer<StepResult> update) {
        this.updateStep(this.storage.getCurrentStep(), update);
    }

    public void updateStep(String uuid, Consumer<StepResult> update) {
        StepResult step = this.storage.getStep(uuid);
        this.notifier.beforeStepUpdate(step);
        update.accept(step);
        this.notifier.afterStepUpdate(step);
    }

    public void stopStep() {
        this.stopStep(this.storage.getCurrentStep());
    }

    public void stopStep(String uuid) {
        StepResult step = this.storage.removeStep(uuid);
        this.notifier.beforeStepStop(step);
        step.setStage(Stage.FINISHED);
        step.setStop(Long.valueOf(System.currentTimeMillis()));
        this.storage.stopStep();
        this.notifier.afterStepStop(step);
    }

    public void addAttachment(String name, String type, String fileExtension, byte[] body) {
        this.addAttachment(name, type, fileExtension, new ByteArrayInputStream(body));
    }

    public void addAttachment(String name, String type, String fileExtension, InputStream stream) {
        this.writeAttachment(this.prepareAttachment(name, type, fileExtension), stream);
    }

    public String prepareAttachment(String name, String type, String fileExtension) {
        String uuid = this.storage.getCurrentStep();
        LOGGER.debug("Adding attachment to item with uuid {}", (Object)uuid);
        String extension = Optional.ofNullable(fileExtension).filter(ext -> !ext.isEmpty()).map(ext -> ext.charAt(0) == '.' ? ext : "." + ext).orElse("");
        String source = UUID.randomUUID().toString() + "-attachment" + extension;
        Attachment attachment = new Attachment().withName(this.isEmpty(name) ? null : name).withType(this.isEmpty(type) ? null : type).withSource(source);
        this.storage.get(uuid, WithAttachments.class).getAttachments().add(attachment);
        return attachment.getSource();
    }

    public void writeAttachment(String attachmentSource, InputStream stream) {
        this.writer.write(attachmentSource, stream);
    }

    private boolean isEmpty(String s) {
        return Objects.isNull(s) || s.isEmpty();
    }

    private static FileSystemResultsWriter getDefaultWriter() {
        String path = System.getProperty("allure.results.directory", "allure-results");
        return new FileSystemResultsWriter(Paths.get(path, new String[0]));
    }
}

