/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.FileSystemResultsWriter;
import io.qameta.allure.internal.AllureStorage;
import io.qameta.allure.listener.ContainerLifecycleListener;
import io.qameta.allure.listener.FixtureLifecycleListener;
import io.qameta.allure.listener.LifecycleNotifier;
import io.qameta.allure.listener.StepLifecycleListener;
import io.qameta.allure.listener.TestLifecycleListener;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.model.WithAttachments;
import io.qameta.allure.util.PropertiesUtils;
import io.qameta.allure.util.ServiceLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureLifecycle.class);
    private final AllureResultsWriter writer;
    private final AllureStorage storage;
    private final LifecycleNotifier notifier;

    public AllureLifecycle() {
        this((AllureResultsWriter)AllureLifecycle.getDefaultWriter());
    }

    public AllureLifecycle(AllureResultsWriter writer) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.notifier = new LifecycleNotifier(ServiceLoaderUtils.load(ContainerLifecycleListener.class, classLoader), ServiceLoaderUtils.load(TestLifecycleListener.class, classLoader), ServiceLoaderUtils.load(FixtureLifecycleListener.class, classLoader), ServiceLoaderUtils.load(StepLifecycleListener.class, classLoader));
        this.writer = writer;
        this.storage = new AllureStorage();
    }

    public void startTestContainer(String parentUuid, TestResultContainer container) {
        this.updateTestContainer(parentUuid, found -> found.getChildren().add(container.getUuid()));
        this.startTestContainer(container);
    }

    public void startTestContainer(TestResultContainer container) {
        this.notifier.beforeContainerStart(container);
        container.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.addContainer(container);
        this.notifier.afterContainerStart(container);
    }

    public void updateTestContainer(String uuid, Consumer<TestResultContainer> update) {
        this.storage.getContainer(uuid).ifPresent(container -> {
            this.notifier.beforeContainerUpdate((TestResultContainer)container);
            update.accept((TestResultContainer)container);
            this.notifier.afterContainerUpdate((TestResultContainer)container);
        });
    }

    public void stopTestContainer(String uuid) {
        this.storage.getContainer(uuid).ifPresent(container -> {
            this.notifier.beforeContainerStop((TestResultContainer)container);
            container.setStop(Long.valueOf(System.currentTimeMillis()));
            this.notifier.afterContainerUpdate((TestResultContainer)container);
        });
    }

    public void writeTestContainer(String uuid) {
        this.storage.removeContainer(uuid).ifPresent(container -> {
            this.notifier.beforeContainerWrite((TestResultContainer)container);
            this.writer.write(container);
            this.notifier.afterContainerWrite((TestResultContainer)container);
        });
    }

    public void startPrepareFixture(String parentUuid, String uuid, FixtureResult result) {
        this.notifier.beforeFixtureStart(result);
        this.updateTestContainer(parentUuid, container -> container.getBefores().add(result));
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    public void startTearDownFixture(String parentUuid, String uuid, FixtureResult result) {
        this.notifier.beforeFixtureStart(result);
        this.updateTestContainer(parentUuid, container -> container.getAfters().add(result));
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    private void startFixture(String uuid, FixtureResult result) {
        this.storage.addFixture(uuid, result);
        result.setStage(Stage.RUNNING);
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.clearStepContext();
        this.storage.startStep(uuid);
    }

    public void updateFixture(Consumer<FixtureResult> update) {
        this.updateFixture(this.storage.getRootStep(), update);
    }

    public void updateFixture(String uuid, Consumer<FixtureResult> update) {
        this.storage.getFixture(uuid).ifPresent(fixture -> {
            this.notifier.beforeFixtureUpdate((FixtureResult)fixture);
            update.accept((FixtureResult)fixture);
            this.notifier.afterFixtureUpdate((FixtureResult)fixture);
        });
    }

    public void stopFixture(String uuid) {
        this.storage.removeFixture(uuid).ifPresent(fixture -> {
            this.notifier.beforeFixtureStop((FixtureResult)fixture);
            this.storage.clearStepContext();
            fixture.setStage(Stage.FINISHED);
            fixture.setStop(Long.valueOf(System.currentTimeMillis()));
            this.notifier.afterFixtureStop((FixtureResult)fixture);
        });
    }

    public Optional<String> getCurrentTestCase() {
        return Optional.ofNullable(this.storage.getRootStep());
    }

    public void scheduleTestCase(String parentUuid, TestResult result) {
        this.updateTestContainer(parentUuid, container -> container.getChildren().add(result.getUuid()));
        this.scheduleTestCase(result);
    }

    public void scheduleTestCase(TestResult result) {
        this.notifier.beforeTestSchedule(result);
        result.setStage(Stage.SCHEDULED);
        this.storage.addTestResult(result);
        this.notifier.afterTestSchedule(result);
    }

    public void startTestCase(String uuid) {
        this.storage.getTestResult(uuid).ifPresent(testResult -> {
            this.notifier.beforeTestStart((TestResult)testResult);
            testResult.withStage(Stage.RUNNING).withStart(Long.valueOf(System.currentTimeMillis()));
            this.storage.clearStepContext();
            this.storage.startStep(uuid);
            this.notifier.afterTestStart((TestResult)testResult);
        });
    }

    public void updateTestCase(Consumer<TestResult> update) {
        String uuid = this.storage.getRootStep();
        this.updateTestCase(uuid, update);
    }

    public void updateTestCase(String uuid, Consumer<TestResult> update) {
        this.storage.getTestResult(uuid).ifPresent(testResult -> {
            this.notifier.beforeTestUpdate((TestResult)testResult);
            update.accept((TestResult)testResult);
            this.notifier.afterTestUpdate((TestResult)testResult);
        });
    }

    public void stopTestCase(String uuid) {
        this.storage.getTestResult(uuid).ifPresent(testResult -> {
            this.notifier.beforeTestStop((TestResult)testResult);
            testResult.withStage(Stage.FINISHED).withStop(Long.valueOf(System.currentTimeMillis()));
            this.storage.clearStepContext();
            this.notifier.afterTestStop((TestResult)testResult);
        });
    }

    public void writeTestCase(String uuid) {
        this.storage.removeTestResult(uuid).ifPresent(testResult -> {
            this.notifier.beforeTestWrite((TestResult)testResult);
            this.writer.write(testResult);
            this.notifier.afterTestWrite((TestResult)testResult);
        });
    }

    public void startStep(String uuid, StepResult result) {
        this.storage.getCurrentStep().ifPresent(parentUuid -> this.startStep((String)parentUuid, uuid, result));
    }

    public void startStep(String parentUuid, String uuid, StepResult result) {
        this.notifier.beforeStepStart(result);
        result.setStage(Stage.RUNNING);
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.startStep(uuid);
        this.storage.addStep(parentUuid, uuid, result);
        this.notifier.afterStepStart(result);
    }

    public void updateStep(Consumer<StepResult> update) {
        this.storage.getCurrentStep().ifPresent(uuid -> this.updateStep((String)uuid, update));
    }

    public void updateStep(String uuid, Consumer<StepResult> update) {
        this.storage.getStep(uuid).ifPresent(step -> {
            this.notifier.beforeStepUpdate((StepResult)step);
            update.accept((StepResult)step);
            this.notifier.afterStepUpdate((StepResult)step);
        });
    }

    public void stopStep() {
        this.storage.getCurrentStep().ifPresent(this::stopStep);
    }

    public void stopStep(String uuid) {
        this.storage.removeStep(uuid).ifPresent(step -> {
            this.notifier.beforeStepStop((StepResult)step);
            step.setStage(Stage.FINISHED);
            step.setStop(Long.valueOf(System.currentTimeMillis()));
            this.storage.stopStep();
            this.notifier.afterStepStop((StepResult)step);
        });
    }

    public void addAttachment(String name, String type, String fileExtension, byte[] body) {
        this.addAttachment(name, type, fileExtension, new ByteArrayInputStream(body));
    }

    public void addAttachment(String name, String type, String fileExtension, InputStream stream) {
        this.writeAttachment(this.prepareAttachment(name, type, fileExtension), stream);
    }

    public String prepareAttachment(String name, String type, String fileExtension) {
        Optional<String> currentStep = this.storage.getCurrentStep();
        currentStep.ifPresent(uuid -> LOGGER.debug("Adding attachment to item with uuid {}", uuid));
        String extension = Optional.ofNullable(fileExtension).filter(ext -> !ext.isEmpty()).map(ext -> ext.charAt(0) == '.' ? ext : "." + ext).orElse("");
        String source = UUID.randomUUID().toString() + "-attachment" + extension;
        Attachment attachment = new Attachment().withName(this.isEmpty(name) ? null : name).withType(this.isEmpty(type) ? null : type).withSource(source);
        currentStep.flatMap(uuid -> this.storage.get((String)uuid, WithAttachments.class)).ifPresent(withAttachments -> withAttachments.getAttachments().add(attachment));
        return attachment.getSource();
    }

    public void writeAttachment(String attachmentSource, InputStream stream) {
        this.writer.write(attachmentSource, stream);
    }

    private boolean isEmpty(String s) {
        return Objects.isNull(s) || s.isEmpty();
    }

    private static FileSystemResultsWriter getDefaultWriter() {
        Properties properties = PropertiesUtils.loadAllureProperties();
        String path = properties.getProperty("allure.results.directory", "allure-results");
        return new FileSystemResultsWriter(Paths.get(path, new String[0]));
    }
}

