/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.test.AllureResults;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;

public class AllureResultsWriterStub
implements AllureResultsWriter,
AllureResults {
    private final List<TestResult> testResults = new CopyOnWriteArrayList<TestResult>();
    private final List<TestResultContainer> testContainers = new CopyOnWriteArrayList<TestResultContainer>();
    private final Map<String, byte[]> attachments = new ConcurrentHashMap<String, byte[]>();

    public void write(TestResult testResult) {
        this.testResults.add(testResult);
    }

    public void write(TestResultContainer testResultContainer) {
        this.testContainers.add(testResultContainer);
    }

    public void write(String source, InputStream attachment) {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)attachment);
            this.attachments.put(source, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read attachment content " + source, e);
        }
    }

    @Override
    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    @Override
    public List<TestResultContainer> getTestResultContainers() {
        return this.testContainers;
    }

    @Override
    public Map<String, byte[]> getAttachments() {
        return this.attachments;
    }
}

