/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;

public class PortValidator
implements IParameterValidator {
    private static final int MAX_PORT_VALUE = 65535;
    private static final String MESSAGE = "invalid port value. Should be an integer between 0 and 65535";

    public void validate(String name, String value) throws ParameterException {
        try {
            int port = Integer.parseInt(value);
            if (port < 0 || port > 65535) {
                throw new ParameterException(MESSAGE);
            }
        }
        catch (NumberFormatException e) {
            throw new ParameterException(MESSAGE, (Throwable)e);
        }
    }
}

