/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;

public class PushGateway {
    private final String address;
    private static final int SECONDS_PER_MILLISECOND = 1000;

    public PushGateway(String address) {
        this.address = address;
    }

    public void push(CollectorRegistry registry, String job, String instance) throws IOException {
        this.doRequest(registry, job, instance, "POST");
    }

    public void push(Collector collector, String job, String instance) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job, instance);
    }

    public void pushAdd(CollectorRegistry registry, String job, String instance) throws IOException {
        this.doRequest(registry, job, instance, "PUT");
    }

    public void pushAdd(Collector collector, String job, String instance) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job, instance);
    }

    public void delete(String job, String instance) throws IOException {
        this.doRequest(null, job, instance, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRequest(CollectorRegistry registry, String job, String instance, String method) throws IOException {
        String url = "http://" + this.address + "/metrics/jobs/" + URLEncoder.encode(job, "UTF-8");
        if (!instance.isEmpty()) {
            url = url + "/instances/" + URLEncoder.encode(instance, "UTF-8");
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        if (!method.equals("DELETE")) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(method);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.connect();
        try {
            int response;
            if (!method.equals("DELETE")) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                TextFormat.write004((Writer)writer, (Enumeration)registry.metricFamilySamples());
                writer.flush();
                writer.close();
            }
            if ((response = connection.getResponseCode()) != 202) {
                throw new IOException("Response code from " + url + " was " + response);
            }
        }
        finally {
            connection.disconnect();
        }
    }
}

