/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;

public class InstrumentedAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    public static final String COUNTER_NAME = "logback_appender_total";
    private static final Counter defaultCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("logback_appender_total")).help("Logback log statements at various log levels")).labelNames(new String[]{"level"})).register();
    private final Counter.Child traceCounter;
    private final Counter.Child debugCounter;
    private final Counter.Child infoCounter;
    private final Counter.Child warnCounter;
    private final Counter.Child errorCounter;

    public InstrumentedAppender() {
        this(defaultCounter);
    }

    public InstrumentedAppender(CollectorRegistry registry) {
        this((Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(COUNTER_NAME)).help("Logback log statements at various log levels")).labelNames(new String[]{"level"})).register(registry));
    }

    private InstrumentedAppender(Counter counter) {
        this.traceCounter = (Counter.Child)counter.labels(new String[]{"trace"});
        this.debugCounter = (Counter.Child)counter.labels(new String[]{"debug"});
        this.infoCounter = (Counter.Child)counter.labels(new String[]{"info"});
        this.warnCounter = (Counter.Child)counter.labels(new String[]{"warn"});
        this.errorCounter = (Counter.Child)counter.labels(new String[]{"error"});
    }

    public void start() {
        super.start();
    }

    protected void append(ILoggingEvent event) {
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.traceCounter.inc();
                break;
            }
            case 10000: {
                this.debugCounter.inc();
                break;
            }
            case 20000: {
                this.infoCounter.inc();
                break;
            }
            case 30000: {
                this.warnCounter.inc();
                break;
            }
            case 40000: {
                this.errorCounter.inc();
                break;
            }
        }
    }
}

