/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.prometheus.metrics.config.ExporterHttpServerProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.exporter.httpserver.DefaultHandler;
import io.prometheus.metrics.exporter.httpserver.HealthyHandler;
import io.prometheus.metrics.exporter.httpserver.MetricsHandler;
import io.prometheus.metrics.exporter.httpserver.NamedDaemonThreadFactory;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HTTPServer
implements Closeable {
    protected final HttpServer server;
    protected final ExecutorService executorService;

    private HTTPServer(PrometheusProperties config, ExecutorService executorService, HttpServer httpServer, PrometheusRegistry registry, Authenticator authenticator, HttpHandler defaultHandler) {
        if (httpServer.getAddress() == null) {
            throw new IllegalArgumentException("HttpServer hasn't been bound to an address");
        }
        this.server = httpServer;
        this.executorService = executorService;
        this.registerHandler("/", defaultHandler == null ? new DefaultHandler() : defaultHandler, authenticator);
        this.registerHandler("/metrics", new MetricsHandler(config, registry), authenticator);
        this.registerHandler("/-/healthy", new HealthyHandler(), authenticator);
        this.server.start();
    }

    private void registerHandler(String path, HttpHandler handler, Authenticator authenticator) {
        HttpContext context = this.server.createContext(path, handler);
        if (authenticator != null) {
            context.setAuthenticator(authenticator);
        }
    }

    public void stop() {
        this.close();
    }

    @Override
    public void close() {
        this.server.stop(0);
        this.executorService.shutdown();
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }

    public static Builder builder() {
        return new Builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    static {
        if (!System.getProperties().containsKey("sun.net.httpserver.maxReqTime")) {
            System.setProperty("sun.net.httpserver.maxReqTime", "60");
        }
        if (!System.getProperties().containsKey("sun.net.httpserver.maxRspTime")) {
            System.setProperty("sun.net.httpserver.maxRspTime", "600");
        }
    }

    public static class Builder {
        private final PrometheusProperties config;
        private Integer port = null;
        private String hostname = null;
        private InetAddress inetAddress = null;
        private InetSocketAddress inetSocketAddress = null;
        private ExecutorService executorService = null;
        private PrometheusRegistry registry = null;
        private ExporterHttpServerProperties properties = null;
        private Authenticator authenticator = null;
        private HttpsConfigurator httpsConfigurator = null;
        private HttpHandler defaultHandler = null;

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder inetAddress(InetAddress address) {
            this.inetAddress = address;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder registry(PrometheusRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder httpsConfigurator(HttpsConfigurator configurator) {
            this.httpsConfigurator = configurator;
            return this;
        }

        public Builder defaultHandler(HttpHandler defaultHandler) {
            this.defaultHandler = defaultHandler;
            return this;
        }

        public HTTPServer buildAndStart() throws IOException {
            HttpServer httpServer;
            if (this.registry == null) {
                this.registry = PrometheusRegistry.defaultRegistry;
            }
            if (this.httpsConfigurator != null) {
                httpServer = HttpsServer.create(this.makeInetSocketAddress(), 3);
                ((HttpsServer)httpServer).setHttpsConfigurator(this.httpsConfigurator);
            } else {
                httpServer = HttpServer.create(this.makeInetSocketAddress(), 3);
            }
            ExecutorService executorService = this.makeExecutorService();
            httpServer.setExecutor(executorService);
            return new HTTPServer(this.config, executorService, httpServer, this.registry, this.authenticator, this.defaultHandler);
        }

        private InetSocketAddress makeInetSocketAddress() {
            if (this.inetSocketAddress != null) {
                this.assertNull(this.port, "cannot configure 'inetSocketAddress' and 'port' at the same time");
                this.assertNull(this.hostname, "cannot configure 'inetSocketAddress' and 'hostname' at the same time");
                this.assertNull(this.inetAddress, "cannot configure 'inetSocketAddress' and 'inetAddress' at the same time");
                return this.inetSocketAddress;
            }
            if (this.inetAddress != null) {
                this.assertNull(this.hostname, "cannot configure 'inetAddress' and 'hostname' at the same time");
                return new InetSocketAddress(this.inetAddress, this.findPort());
            }
            if (this.hostname != null) {
                return new InetSocketAddress(this.hostname, this.findPort());
            }
            return new InetSocketAddress(this.findPort());
        }

        private ExecutorService makeExecutorService() {
            if (this.executorService != null) {
                return this.executorService;
            }
            return new ThreadPoolExecutor(1, 10, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), NamedDaemonThreadFactory.defaultThreadFactory(true), new BlockingRejectedExecutionHandler());
        }

        private int findPort() {
            if (this.properties != null && this.properties.getPort() != null) {
                return this.properties.getPort();
            }
            if (this.port != null) {
                return this.port;
            }
            return 0;
        }

        private void assertNull(Object o, String msg) {
            if (o != null) {
                throw new IllegalStateException(msg);
            }
        }
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private BlockingRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                try {
                    threadPoolExecutor.getQueue().put(runnable);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

