/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound.integration;

import com.google.auto.service.AutoService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.scheduler.NonBlocking;

@AutoService(value={BlockHoundIntegration.class})
public class ReactorIntegration
implements BlockHoundIntegration {
    @Override
    public void applyTo(BlockHound.Builder builder) {
        try {
            Class.forName("reactor.core.publisher.Flux");
        }
        catch (ClassNotFoundException ignored) {
            return;
        }
        try {
            Class.forName("reactor.core.CorePublisher");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName(), "scheduleAtFixedRate");
            builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
            builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
            return;
        }
    }
}

