/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.shaded.net.bytebuddy.utility.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.tools.shaded.net.bytebuddy.jar.asm.Handle;
import reactor.tools.shaded.net.bytebuddy.jar.asm.Label;
import reactor.tools.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import reactor.tools.shaded.net.bytebuddy.utility.OpenedClassReader;

public class FramePaddingMethodVisitor
extends MethodVisitor {
    private boolean padding = false;
    private boolean injected = false;
    private final List<Label> labels = new ArrayList<Label>();
    private final Map<Label, Label> mapped = new HashMap<Label, Label>();

    public FramePaddingMethodVisitor(MethodVisitor methodVisitor) {
        super(OpenedClassReader.ASM_API, methodVisitor);
    }

    public void visitLabel(Label label) {
        this.labels.add(label);
        super.visitLabel(label);
    }

    public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
        if (this.padding) {
            this.injected = true;
            super.visitInsn(0);
        } else {
            this.padding = true;
        }
        if (!this.mapped.isEmpty()) {
            this.patch(localVariableLength, localVariable);
            this.patch(stackSize, stack);
        }
        super.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
    }

    public void visitInsn(int opcode) {
        this.reset();
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.reset();
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int offset) {
        this.reset();
        super.visitVarInsn(opcode, offset);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.reset();
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.reset();
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.reset();
        super.visitMethodInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.reset();
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle handle, Object ... argument) {
        this.reset();
        super.visitInvokeDynamicInsn(name, descriptor, handle, argument);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.reset();
        super.visitJumpInsn(opcode, label);
    }

    public void visitLdcInsn(Object value) {
        this.reset();
        super.visitLdcInsn(value);
    }

    public void visitIincInsn(int offset, int increment) {
        this.reset();
        super.visitIincInsn(offset, increment);
    }

    public void visitTableSwitchInsn(int minimum, int maximum, Label defaultLabel, Label ... label) {
        this.reset();
        super.visitTableSwitchInsn(minimum, maximum, defaultLabel, label);
    }

    public void visitLookupSwitchInsn(Label defaultLabel, int[] key, Label[] label) {
        this.reset();
        super.visitLookupSwitchInsn(defaultLabel, key, label);
    }

    public void visitMultiANewArrayInsn(String descriptor, int dimensions) {
        this.reset();
        super.visitMultiANewArrayInsn(descriptor, dimensions);
    }

    private void patch(int length, Object[] target) {
        if (target != null) {
            for (int index = 0; index < length; ++index) {
                Label label;
                if (!(target[index] instanceof Label) || (label = this.mapped.get((Label)target[index])) == null) continue;
                target[index] = label;
            }
        }
    }

    private void reset() {
        if (this.padding) {
            if (this.injected) {
                for (Label label : this.labels) {
                    Label target = new Label();
                    super.visitLabel(target);
                    this.mapped.put(label, target);
                }
                this.injected = false;
            }
            this.padding = false;
        }
        this.labels.clear();
    }
}

