/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import reactor.tools.agent.CallSiteInfoAddingMethodVisitor;
import reactor.tools.shaded.org.objectweb.asm.Label;
import reactor.tools.shaded.org.objectweb.asm.MethodVisitor;
import reactor.tools.shaded.org.objectweb.asm.Type;

class ReturnHandlingMethodVisitor
extends MethodVisitor {
    final AtomicBoolean changed;
    final String currentClassName;
    final String currentMethod;
    final String returnType;
    final String currentSource;
    int currentLine = -1;
    boolean checkpointed = false;

    ReturnHandlingMethodVisitor(MethodVisitor visitor, String returnType, String currentClassName, String currentMethod, String currentSource, AtomicBoolean changed) {
        super(458752, visitor);
        this.changed = changed;
        this.currentClassName = currentClassName;
        this.currentMethod = currentMethod;
        this.returnType = returnType;
        this.currentSource = currentSource;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        String returnType;
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (!this.checkpointed && CallSiteInfoAddingMethodVisitor.isCorePublisher(owner) && (returnType = Type.getReturnType(descriptor).getInternalName()).startsWith("reactor/core/publisher/")) {
            this.checkpointed = true;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (!this.checkpointed && 176 == opcode) {
            this.changed.set(true);
            String callSite = String.format("at %s.%s(%s:%d)", this.currentClassName.replace("/", "."), this.currentMethod, this.currentSource, this.currentLine);
            super.visitLdcInsn(callSite);
            super.visitMethodInsn(184, "reactor/core/publisher/Hooks", "addReturnInfo", "(Lorg/reactivestreams/Publisher;Ljava/lang/String;)Lorg/reactivestreams/Publisher;", false);
            super.visitTypeInsn(192, this.returnType);
        }
        super.visitInsn(opcode);
    }
}

