/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.lang.reflect.Field;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class LoggerUtils {
    @Nullable
    static CapturingFactory currentCapturingFactory;

    private LoggerUtils() {
    }

    public static Disposable useCurrentLoggersWithCapture() throws IllegalStateException {
        try {
            CapturingFactory capturingFactory;
            Field lfField = Loggers.class.getDeclaredField("LOGGER_FACTORY");
            lfField.setAccessible(true);
            Object originalFactoryInstance = lfField.get(Loggers.class);
            if (originalFactoryInstance instanceof CapturingFactory) {
                return (Disposable)originalFactoryInstance;
            }
            Function originalFactory = (Function)originalFactoryInstance;
            currentCapturingFactory = capturingFactory = new CapturingFactory(originalFactory);
            Loggers.useCustomLoggers((Function)capturingFactory);
            return capturingFactory;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not install custom logger", e);
        }
    }

    public static void enableCaptureWith(Logger testLogger) {
        CapturingFactory f = currentCapturingFactory;
        if (f == null) {
            throw new IllegalStateException("LoggerUtils#useCurrentLoggerWithCapture() hasn't been called");
        }
        f.enableRedirection(testLogger, true);
    }

    public static void enableCaptureWith(Logger testLogger, boolean redirectToOriginal) {
        CapturingFactory f = currentCapturingFactory;
        if (f == null) {
            throw new IllegalStateException("LoggerUtils#useCurrentLoggerWithCapture() hasn't been called");
        }
        f.enableRedirection(testLogger, redirectToOriginal);
    }

    public static void disableCapture() {
        CapturingFactory f = currentCapturingFactory;
        if (f == null) {
            throw new IllegalStateException("LoggerUtils#useCurrentLoggerWithCapture() hasn't been called");
        }
        f.disableRedirection();
    }

    static class DivertingLogger
    implements Logger {
        private final Logger delegate;
        private final CapturingFactory parent;

        DivertingLogger(Logger delegate, CapturingFactory parent) {
            this.delegate = delegate;
            this.parent = parent;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isTraceEnabled() {
            Logger logger = this.parent.getCapturingLogger();
            return this.delegate.isTraceEnabled() || logger != null && logger.isTraceEnabled();
        }

        public void trace(String msg) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.trace(msg);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.trace(msg);
            }
        }

        public void trace(String format, Object ... arguments) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.trace(format, arguments);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.trace(format, arguments);
            }
        }

        public void trace(String msg, Throwable t) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.trace(msg, t);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.trace(msg, t);
            }
        }

        public boolean isDebugEnabled() {
            Logger logger = this.parent.getCapturingLogger();
            return this.delegate.isDebugEnabled() || logger != null && logger.isDebugEnabled();
        }

        public void debug(String msg) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.debug(msg);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.debug(msg);
            }
        }

        public void debug(String format, Object ... arguments) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.debug(format, arguments);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.debug(format, arguments);
            }
        }

        public void debug(String msg, Throwable t) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.debug(msg, t);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.debug(msg, t);
            }
        }

        public boolean isInfoEnabled() {
            Logger logger = this.parent.getCapturingLogger();
            return this.delegate.isInfoEnabled() || logger != null && logger.isInfoEnabled();
        }

        public void info(String msg) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.info(msg);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.info(msg);
            }
        }

        public void info(String format, Object ... arguments) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.info(format, arguments);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.info(format, arguments);
            }
        }

        public void info(String msg, Throwable t) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.info(msg, t);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.info(msg, t);
            }
        }

        public boolean isWarnEnabled() {
            Logger logger = this.parent.getCapturingLogger();
            return this.delegate.isWarnEnabled() || logger != null && logger.isWarnEnabled();
        }

        public void warn(String msg) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.warn(msg);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.warn(msg);
            }
        }

        public void warn(String format, Object ... arguments) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.warn(format, arguments);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.warn(format, arguments);
            }
        }

        public void warn(String msg, Throwable t) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.warn(msg, t);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.warn(msg, t);
            }
        }

        public boolean isErrorEnabled() {
            Logger logger = this.parent.getCapturingLogger();
            return this.delegate.isErrorEnabled() || logger != null && logger.isErrorEnabled();
        }

        public void error(String msg) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.error(msg);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.error(msg);
            }
        }

        public void error(String format, Object ... arguments) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.error(format, arguments);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.error(format, arguments);
            }
        }

        public void error(String msg, Throwable t) {
            Logger logger = this.parent.getCapturingLogger();
            if (logger != null) {
                logger.error(msg, t);
            }
            if (this.parent.isRedirectToOriginal()) {
                this.delegate.error(msg, t);
            }
        }
    }

    static final class CapturingFactory
    implements Function<String, Logger>,
    Disposable {
        final Function<String, ? extends Logger> originalFactory;
        @Nullable
        Logger capturingLogger;
        boolean redirectToOriginal;

        CapturingFactory(Function<String, ? extends Logger> originalFactory) {
            this.originalFactory = originalFactory;
            this.disableRedirection();
        }

        void disableRedirection() {
            this.redirectToOriginal = true;
            this.capturingLogger = null;
        }

        void enableRedirection(Logger captureLogger, boolean redirectToOriginal) {
            if (this.capturingLogger != null) {
                throw new IllegalStateException("A logger was already set, maybe from a previous run. Don't forget to call disableCapture()");
            }
            this.redirectToOriginal = redirectToOriginal;
            this.capturingLogger = captureLogger;
        }

        @Nullable
        Logger getCapturingLogger() {
            return this.capturingLogger;
        }

        boolean isRedirectToOriginal() {
            return this.redirectToOriginal;
        }

        @Override
        public Logger apply(String category) {
            Logger original = this.originalFactory.apply(category);
            return new DivertingLogger(original, this);
        }

        public void dispose() {
            if (currentCapturingFactory == this) {
                currentCapturingFactory = null;
            }
            try {
                Field lfField = Loggers.class.getDeclaredField("LOGGER_FACTORY");
                lfField.setAccessible(true);
                Object o = lfField.get(Loggers.class);
                if (!(Loggers.getLogger(LoggerUtils.class) instanceof DivertingLogger)) {
                    throw new IllegalStateException("Expected the current factory to be " + this + ", found " + o + " instead");
                }
                lfField.set(Loggers.class, this.originalFactory);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

