/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.publisher;

import java.util.concurrent.atomic.AtomicLongArray;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface PublisherProbe<T> {
    default public void assertWasNotSubscribed() {
        if (this.wasSubscribed()) {
            throw new AssertionError((Object)"PublisherProbe should not have been subscribed but it was");
        }
    }

    default public void assertWasSubscribed() {
        if (!this.wasSubscribed()) {
            throw new AssertionError((Object)"PublisherProbe should have been subscribed but it wasn't");
        }
    }

    default public void assertWasNotCancelled() {
        if (this.wasCancelled()) {
            throw new AssertionError((Object)"PublisherProbe should not have been cancelled but it was");
        }
    }

    default public void assertWasCancelled() {
        if (!this.wasCancelled()) {
            throw new AssertionError((Object)"PublisherProbe should have been cancelled but it wasn't");
        }
    }

    default public void assertWasNotRequested() {
        if (this.wasRequested()) {
            throw new AssertionError((Object)"PublisherProbe should not have been requested but it was");
        }
    }

    default public void assertWasRequested() {
        if (!this.wasRequested()) {
            throw new AssertionError((Object)"PublisherProbe should have been requested but it wasn't");
        }
    }

    public Mono<T> mono();

    public Flux<T> flux();

    public boolean wasSubscribed();

    public long subscribeCount();

    public boolean wasCancelled();

    public boolean wasRequested();

    public static <T> PublisherProbe<T> of(Publisher<? extends T> source) {
        return new DefaultPublisherProbe<T>(source);
    }

    public static <T> PublisherProbe<T> empty() {
        return new DefaultPublisherProbe(Mono.empty());
    }

    public static final class DefaultPublisherProbe<T>
    extends AtomicLongArray
    implements PublisherProbe<T> {
        private static final int SUBSCRIBED = 0;
        private static final int CANCELLED = 1;
        private static final int REQUESTED = 2;
        final Publisher<T> delegate;

        DefaultPublisherProbe(Publisher<? extends T> delegate) {
            super(3);
            this.delegate = delegate;
        }

        @Override
        public Mono<T> mono() {
            return Mono.from(this.delegate).doOnSubscribe(sub -> this.incrementAndGet(0)).doOnCancel(() -> this.incrementAndGet(1)).doOnRequest(l -> this.incrementAndGet(2));
        }

        @Override
        public Flux<T> flux() {
            return Flux.from(this.delegate).doOnSubscribe(sub -> this.incrementAndGet(0)).doOnCancel(() -> this.incrementAndGet(1)).doOnRequest(l -> this.incrementAndGet(2));
        }

        @Override
        public boolean wasSubscribed() {
            return this.get(0) > 0L;
        }

        @Override
        public long subscribeCount() {
            return this.get(0);
        }

        @Override
        public boolean wasCancelled() {
            return this.get(1) > 0L;
        }

        @Override
        public boolean wasRequested() {
            return this.get(2) > 0L;
        }
    }
}

