/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.control;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.dispatch.TailRecurseDispatcher;
import reactor.fn.Consumer;
import reactor.rx.action.Action;

public class RepeatAction<T>
extends Action<T, T> {
    private final long numRetries;
    private long currentNumRetries = 0L;
    private final Publisher<? extends T> rootPublisher;
    private Dispatcher dispatcher;
    private long pendingRequests = 0L;

    public RepeatAction(Dispatcher dispatcher, int numRetries, Publisher<? extends T> parentStream) {
        this.numRetries = numRetries;
        this.dispatcher = SynchronousDispatcher.INSTANCE == dispatcher ? Environment.tailRecurse() : dispatcher;
        this.rootPublisher = parentStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
        if (this.capacity != Long.MAX_VALUE && this.pendingRequests != Long.MAX_VALUE) {
            RepeatAction repeatAction = this;
            synchronized (repeatAction) {
                if (this.pendingRequests != Long.MAX_VALUE) {
                    --this.pendingRequests;
                }
            }
        }
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        long pendingRequests = this.pendingRequests;
        if (pendingRequests > 0L) {
            subscription.request(pendingRequests);
        }
    }

    @Override
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestMore(long n) {
        RepeatAction repeatAction = this;
        synchronized (repeatAction) {
            if ((this.pendingRequests += n) < 0L) {
                this.pendingRequests = Long.MAX_VALUE;
            }
        }
        super.requestMore(n);
    }

    @Override
    public void onComplete() {
        this.cancel();
        this.dispatcher.dispatch(null, (Consumer)new Consumer<Void>(){

            public void accept(Void nothing) {
                if (RepeatAction.this.numRetries != -1L && ++RepeatAction.this.currentNumRetries > RepeatAction.this.numRetries) {
                    RepeatAction.super.onComplete();
                    RepeatAction.this.currentNumRetries = 0L;
                } else if (RepeatAction.this.rootPublisher != null) {
                    if (TailRecurseDispatcher.class.isAssignableFrom(RepeatAction.this.dispatcher.getClass())) {
                        RepeatAction.this.dispatcher.shutdown();
                        RepeatAction.this.dispatcher = (Dispatcher)Environment.tailRecurse();
                    }
                    RepeatAction.this.rootPublisher.subscribe((Subscriber)RepeatAction.this);
                }
            }
        }, null);
    }
}

