/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.control;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.dispatch.TailRecurseDispatcher;
import reactor.fn.Consumer;
import reactor.rx.action.Action;
import reactor.rx.subscription.PushSubscription;

public final class DispatcherAction<T>
extends Action<T, T> {
    private final Dispatcher dispatcher;
    private final Dispatcher requestDispatcher;
    private volatile long pendingRequests = 0L;
    private final AtomicLongFieldUpdater<DispatcherAction> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(DispatcherAction.class, "pendingRequests");

    public DispatcherAction(Dispatcher dispatcher, Dispatcher requestDispatcher) {
        this.dispatcher = dispatcher;
        this.requestDispatcher = requestDispatcher != SynchronousDispatcher.INSTANCE ? dispatcher : requestDispatcher;
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return this.dispatcher != dispatcher;
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        long toRequest = this.PENDING_UPDATER.getAndSet(this, 0L);
        if (toRequest > 0L) {
            this.requestMore(toRequest);
        }
    }

    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        this.requestMore(elements);
    }

    @Override
    public void requestMore(long n) {
        Action.checkRequest(n);
        long toRequest = n != Long.MAX_VALUE ? Math.min(this.capacity, n) : Long.MAX_VALUE;
        PushSubscription upstreamSubscription = this.upstreamSubscription;
        if (upstreamSubscription != null) {
            long l = toRequest = (toRequest -= Math.max(upstreamSubscription.pendingRequestSignals(), 0L)) < 0L ? 0L : toRequest;
            if (n == Long.MAX_VALUE || this.PENDING_UPDATER.addAndGet(this, n - toRequest) < 0L) {
                this.PENDING_UPDATER.set(this, Long.MAX_VALUE);
            }
            if (toRequest > 0L) {
                if (this.requestDispatcher.inContext()) {
                    this.requestDispatcher.dispatch((Object)toRequest, (Consumer)upstreamSubscription, null);
                } else if (this.requestDispatcher == SynchronousDispatcher.INSTANCE) {
                    TailRecurseDispatcher.INSTANCE.dispatch((Object)toRequest, (Consumer)upstreamSubscription, null);
                } else {
                    upstreamSubscription.request(toRequest);
                }
            }
        } else if (n == Long.MAX_VALUE || this.PENDING_UPDATER.addAndGet(this, n) < 0L) {
            this.PENDING_UPDATER.set(this, Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T ev) {
        if (ev == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        if (this.dispatcher.inContext()) {
            super.onNext(ev);
        } else {
            this.dispatcher.dispatch(ev, (Consumer)this, null);
        }
    }

    @Override
    public void onError(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        if (this.dispatcher.inContext()) {
            super.onError(cause);
        } else {
            this.dispatcher.dispatch((Object)cause, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    DispatcherAction.super.onError(throwable);
                }
            }, null);
        }
    }

    @Override
    public void onComplete() {
        if (this.dispatcher.inContext()) {
            super.onComplete();
        } else {
            this.dispatcher.dispatch(null, (Consumer)new Consumer<Void>(){

                public void accept(Void aVoid) {
                    DispatcherAction.super.onComplete();
                }
            }, null);
        }
    }

    @Override
    protected void doNext(T ev) {
        long toRequest;
        this.broadcastNext(ev);
        PushSubscription sub = this.upstreamSubscription;
        if (sub != null && this.pendingRequests != Long.MAX_VALUE && sub.pendingRequestSignals() == 0L && (toRequest = this.PENDING_UPDATER.getAndSet(this, 0L)) > 0L) {
            this.requestMore(toRequest);
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String toString() {
        return super.toString() + "{overflow=" + this.pendingRequests + "}";
    }
}

