/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientConnect;
import reactor.netty.tcp.TcpClientOperator;

final class TcpClientRunOn
extends TcpClientOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpClientRunOn(TcpClient client, LoopResources loopResources, boolean preferNative) {
        super(client);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b;
        Integer maxConnections = (Integer)(b = this.source.configure()).config().attrs().get(TcpClientConnect.MAX_CONNECTIONS);
        TcpClientRunOn.configure(b, this.preferNative, this.loopResources, maxConnections != null && maxConnections != -1);
        return b;
    }

    static void configure(Bootstrap b, boolean preferNative, LoopResources resources, boolean useDelegate) {
        EventLoopGroup elg = resources.onClient(preferNative);
        if (useDelegate && elg instanceof Supplier) {
            EventLoopGroup delegate = (EventLoopGroup)((Supplier)elg).get();
            ((Bootstrap)b.group(delegate)).channel(resources.onChannel(delegate));
        } else {
            ((Bootstrap)b.group(elg)).channel(resources.onChannel(elg));
        }
    }
}

