/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.TcpUtils;

public final class ProxyProvider {
    private static final Supplier<? extends HttpHeaders> NO_HTTP_HEADERS = () -> null;
    final String username;
    final Function<? super String, ? extends String> password;
    final Supplier<? extends InetSocketAddress> address;
    final Pattern nonProxyHosts;
    final Supplier<? extends HttpHeaders> httpHeaders;
    final Proxy type;

    public static TypeSpec builder() {
        return new Build();
    }

    @Nullable
    public static ProxyProvider findProxySupport(Bootstrap b) {
        DeferredProxySupport proxy = BootstrapHandlers.findConfiguration(DeferredProxySupport.class, b.config().handler());
        if (proxy == null) {
            return null;
        }
        return proxy.proxyProvider;
    }

    ProxyProvider(Build builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.address = Objects.isNull(builder.address) ? () -> InetSocketAddressUtil.createResolved(builder.host, builder.port) : builder.address;
        this.nonProxyHosts = builder.nonProxyHosts != null ? Pattern.compile(builder.nonProxyHosts, 2) : null;
        this.httpHeaders = Objects.isNull(builder.httpHeaders) ? NO_HTTP_HEADERS : builder.httpHeaders;
        this.type = builder.type;
    }

    public final Proxy getType() {
        return this.type;
    }

    public final Supplier<? extends InetSocketAddress> getAddress() {
        return this.address;
    }

    public final Pattern getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public final ProxyHandler newProxyHandler() {
        InetSocketAddress proxyAddr = this.address.get();
        String username = this.username;
        String password = Objects.nonNull(username) && Objects.nonNull(this.password) ? this.password.apply(username) : null;
        switch (this.type) {
            case HTTP: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new HttpProxyHandler((SocketAddress)proxyAddr, username, password, this.httpHeaders.get()) : new HttpProxyHandler((SocketAddress)proxyAddr, this.httpHeaders.get());
            }
            case SOCKS4: {
                return Objects.nonNull(username) ? new Socks4ProxyHandler((SocketAddress)proxyAddr, username) : new Socks4ProxyHandler((SocketAddress)proxyAddr);
            }
            case SOCKS5: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new Socks5ProxyHandler((SocketAddress)proxyAddr, username, password) : new Socks5ProxyHandler((SocketAddress)proxyAddr);
            }
        }
        throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
    }

    public boolean shouldProxy(SocketAddress address) {
        SocketAddress addr = address;
        if (address instanceof TcpUtils.SocketAddressSupplier) {
            addr = ((TcpUtils.SocketAddressSupplier)address).get();
        }
        return addr instanceof InetSocketAddress && this.shouldProxy(((InetSocketAddress)addr).getHostString());
    }

    public boolean shouldProxy(@Nullable String hostName) {
        return this.nonProxyHosts == null || hostName == null || !this.nonProxyHosts.matcher(hostName).matches();
    }

    public String asSimpleString() {
        return "proxy=" + (Object)((Object)this.type) + "(" + this.address.get() + ")";
    }

    public String asDetailedString() {
        return "address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHosts + ", type=" + (Object)((Object)this.type);
    }

    public String toString() {
        return "ProxyProvider{" + this.asDetailedString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyProvider that = (ProxyProvider)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.getPasswordValue(), that.getPasswordValue()) && Objects.equals(this.getAddress().get(), that.getAddress().get()) && Objects.equals(this.getNonProxyHostsValue(), that.getNonProxyHostsValue()) && Objects.equals(this.httpHeaders.get(), that.httpHeaders.get()) && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.username, this.getPasswordValue(), this.getAddress().get(), this.getNonProxyHostsValue(), this.httpHeaders.get(), this.getType()});
    }

    private String getNonProxyHostsValue() {
        return this.getNonProxyHosts() == null ? null : this.getNonProxyHosts().toString();
    }

    @Nullable
    private String getPasswordValue() {
        if (this.username == null || this.password == null) {
            return null;
        }
        return this.password.apply(this.username);
    }

    static final class ProxySupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final Bootstrap bootstrap;
        final ProxyProvider proxyProvider;

        ProxySupportConsumer(Bootstrap bootstrap, ProxyProvider proxyProvider) {
            this.bootstrap = bootstrap;
            this.proxyProvider = proxyProvider;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            if (this.proxyProvider.shouldProxy(this.bootstrap.config().remoteAddress())) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addFirst("reactor.left.proxyHandler", (ChannelHandler)this.proxyProvider.newProxyHandler());
                if (channel.pipeline().get("reactor.left.loggingHandler") != null) {
                    pipeline.addBefore("reactor.left.proxyHandler", "reactor.left.proxyLoggingHandler", (ChannelHandler)new LoggingHandler("reactor.netty.proxy"));
                }
            }
        }
    }

    static final class DeferredProxySupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final ProxyProvider proxyProvider;

        DeferredProxySupport(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            return new ProxySupportConsumer(bootstrap, this.proxyProvider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredProxySupport that = (DeferredProxySupport)o;
            return Objects.equals(this.proxyProvider, that.proxyProvider);
        }

        public int hashCode() {
            return Objects.hash(this.proxyProvider);
        }
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public Builder httpHeaders(Consumer<HttpHeaders> var1);

        public ProxyProvider build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        public Builder address(InetSocketAddress var1);

        public Builder address(Supplier<? extends InetSocketAddress> var1);
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        String username;
        Function<? super String, ? extends String> password;
        String host;
        int port;
        Supplier<? extends InetSocketAddress> address;
        String nonProxyHosts;
        Supplier<? extends HttpHeaders> httpHeaders;
        Proxy type;

        Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> InetSocketAddressUtil.replaceWithResolved(address);
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            this.nonProxyHosts = nonProxyHostsPattern;
            return this;
        }

        @Override
        public Builder httpHeaders(final Consumer<HttpHeaders> headers) {
            this.httpHeaders = () -> new DefaultHttpHeaders(){
                {
                    headers.accept(this);
                }
            };
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public ProxyProvider build() {
            return new ProxyProvider(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

