/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.ReactorNetty;
import reactor.ipc.netty.http.client.HttpClientOperations;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

final class HttpClientWSOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound,
BiConsumer<Void, Throwable> {
    final WebSocketClientHandshaker handshaker;
    final ChannelPromise handshakerResult;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<HttpClientWSOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(HttpClientWSOperations.class, "closeSent");

    HttpClientWSOperations(URI currentURI, String protocols, HttpClientOperations replaced) {
        super(replaced.channel(), replaced);
        Channel channel = this.channel();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)currentURI, (WebSocketVersion)WebSocketVersion.V13, (String)protocols, (boolean)true, (HttpHeaders)replaced.requestHeaders().remove((CharSequence)HttpHeaderNames.HOST));
        this.handshakerResult = channel.newPromise();
        this.handshaker.handshake(channel).addListener(f -> {
            this.markPersistent(false);
            channel.read();
        });
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse((HttpResponse)response);
            if (this.checkResponseCode((HttpResponse)response)) {
                try {
                    if (!this.handshaker.isHandshakeComplete()) {
                        this.handshaker.finishHandshake(this.channel(), response);
                    }
                }
                catch (WebSocketHandshakeException wshe) {
                    if (this.serverError) {
                        this.onInboundError(wshe);
                        return;
                    }
                }
                finally {
                    response.content().release();
                }
                this.parentContext().fireContextActive(this);
                this.handshakerResult.trySuccess();
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            this.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            this.onInboundComplete();
            CloseWebSocketFrame close = (CloseWebSocketFrame)msg;
            this.sendCloseNow(new CloseWebSocketFrame(true, close.rsv(), close.content()));
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    public WebsocketInbound receiveWebsocket() {
        return this;
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Cancelling Websocket inbound. Closing Websocket"));
        }
        this.sendCloseNow(null);
    }

    @Override
    protected void onInboundClose() {
        this.onHandlerTerminate();
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendCloseNow(new CloseWebSocketFrame(1002, "Client internal error"));
        }
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            this.context().onClose(() -> ReactorNetty.safeRelease(frame));
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.channel().pipeline().remove("reactor.right.reactiveBridge");
                    return this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            });
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.channel().writeAndFlush((Object)(frame == null ? new CloseWebSocketFrame() : frame)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (frame != null) {
            frame.release();
        }
    }

    @Override
    public void accept(Void aVoid, Throwable throwable) {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Handler terminated. Closing Websocket"));
        }
        if (throwable == null) {
            if (this.channel().isActive()) {
                this.sendCloseNow(null);
            }
        } else {
            this.onOutboundError(throwable);
        }
    }
}

