/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.core.scheduler.TimedScheduler;

public final class RxJava2Scheduler
implements TimedScheduler {
    final Scheduler scheduler;

    public static TimedScheduler from(Scheduler scheduler) {
        return new RxJava2Scheduler(scheduler);
    }

    RxJava2Scheduler(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public reactor.core.Disposable schedule(Runnable task) {
        Disposable s = this.scheduler.scheduleDirect(task);
        return () -> ((Disposable)s).dispose();
    }

    public reactor.core.Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        Disposable s = this.scheduler.scheduleDirect(task, delay, unit);
        return () -> ((Disposable)s).dispose();
    }

    public reactor.core.Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Disposable s = this.scheduler.schedulePeriodicallyDirect(task, initialDelay, period, unit);
        return () -> ((Disposable)s).dispose();
    }

    public TimedScheduler.TimedWorker createWorker() {
        return new RxSchedulerWorker(this.scheduler.createWorker());
    }

    static final class RxSchedulerWorker
    implements TimedScheduler.TimedWorker {
        final Scheduler.Worker w;

        public RxSchedulerWorker(Scheduler.Worker w) {
            this.w = w;
        }

        public reactor.core.Disposable schedule(Runnable task) {
            Disposable s = this.w.schedule(task);
            return () -> ((Disposable)s).dispose();
        }

        public void shutdown() {
            this.w.dispose();
        }

        public reactor.core.Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            Disposable s = this.w.schedule(task, delay, unit);
            return () -> ((Disposable)s).dispose();
        }

        public reactor.core.Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            Disposable s = this.w.schedulePeriodically(task, initialDelay, period, unit);
            return () -> ((Disposable)s).dispose();
        }
    }
}

