/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.UuidType;
import java.util.UUID;

public final class UuidOperators {
    private UuidOperators() {
    }

    @Description(value="Generates a random UUID")
    @ScalarFunction(deterministic=false)
    @SqlType(value="uuid")
    public static Slice uuid() {
        UUID uuid = UUID.randomUUID();
        return Slices.wrappedLongArray((long[])new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="uuid") Slice left, @SqlType(value="uuid") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="uuid") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="uuid") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="uuid")
    public static Slice castFromVarcharToUuid(@SqlType(value="varchar(x)") Slice slice) {
        try {
            UUID uuid = UUID.fromString(slice.toStringUtf8());
            if (slice.length() == 36) {
                return Slices.wrappedLongArray((long[])new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid UUID string length: " + slice.length());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to UUID: " + slice.toStringUtf8());
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castFromUuidToVarchar(@SqlType(value="uuid") Slice slice) {
        return Slices.utf8Slice((String)new UUID(slice.getLong(0), slice.getLong(8)).toString());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="uuid")
    public static Slice castFromVarbinaryToUuid(@SqlType(value="varbinary") Slice slice) {
        if (slice.length() == 16) {
            return slice;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid UUID binary length: " + slice.length());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castFromUuidToVarbinary(@SqlType(value="uuid") Slice slice) {
        return Slices.wrappedBuffer((byte[])slice.getBytes());
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="uuid") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class UuidDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="uuid") Slice left, @IsNull boolean leftNull, @SqlType(value="uuid") Slice right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return UuidOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="uuid", nativeContainerType=Slice.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="uuid", nativeContainerType=Slice.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return !UuidType.UUID.equalTo(left, leftPosition, right, rightPosition);
        }
    }
}

