/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeUtils;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time with time zone")
    public static long castToTimeWithTimeZone(ConnectorSession session, @SqlType(value="time") long value) {
        if (session.isLegacyTimestamp()) {
            return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeEncoding.packDateTimeWithZone((long)localChronology.getZone().convertLocalToUTC(value, false), (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(ConnectorSession session, @SqlType(value="time") long value) {
        if (session.isLegacyTimestamp()) {
            return Slices.utf8Slice((String)DateTimeUtils.printTimeWithoutTimeZone(session.getTimeZoneKey(), value));
        }
        return Slices.utf8Slice((String)DateTimeUtils.printTimeWithoutTimeZone(value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="time")
    public static long castFromSlice(ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        try {
            if (session.isLegacyTimestamp()) {
                return DateTimeUtils.parseLegacyTime(session.getTimeZoneKey(), value.toStringUtf8());
            }
            return DateTimeUtils.parseTimeWithoutTimeZone(value.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="time") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="time") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="time") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class TimeDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="time") long left, @IsNull boolean leftNull, @SqlType(value="time") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return TimeOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="time", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="time", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return TimeOperators.notEqual(TimeType.TIME.getLong(left, leftPosition), TimeType.TIME.getLong(right, rightPosition));
        }
    }
}

