/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.JsonPath;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.AbstractVariableWidthType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;

public class JsonPathType
extends AbstractVariableWidthType {
    public static final JsonPathType JSON_PATH = new JsonPathType();
    public static final String NAME = "JsonPath";

    private JsonPathType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), JsonPath.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new JsonPath(block.getSlice(position, 0, block.getSliceLength(position)).toStringUtf8());
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Slice pattern = Slices.utf8Slice((String)((JsonPath)value).pattern());
        blockBuilder.writeBytes(pattern, 0, pattern.length()).closeEntry();
    }
}

