/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControlConfig;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import io.prestosql.transaction.TransactionManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Qualifier;

public class TestingAccessControlManager
extends AccessControlManager {
    private final Set<TestingPrivilege> denyPrivileges = new HashSet<TestingPrivilege>();
    private final Map<RowFilterKey, List<ViewExpression>> rowFilters = new HashMap<RowFilterKey, List<ViewExpression>>();
    private final Map<ColumnMaskKey, List<ViewExpression>> columnMasks = new HashMap<ColumnMaskKey, List<ViewExpression>>();
    private Predicate<String> deniedCatalogs = s -> true;
    private Predicate<SchemaTableName> deniedTables = s -> true;

    @Inject
    public TestingAccessControlManager(TransactionManager transactionManager, EventListenerManager eventListenerManager) {
        super(transactionManager, eventListenerManager, new AccessControlConfig());
    }

    public void loadSystemAccessControl(String name, Map<String, String> properties) {
        this.setSystemAccessControl(name, properties);
    }

    public static TestingPrivilege privilege(String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.empty(), entityName, type);
    }

    public static TestingPrivilege privilege(String userName, String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.of(userName), entityName, type);
    }

    public void deny(TestingPrivilege ... deniedPrivileges) {
        Collections.addAll(this.denyPrivileges, deniedPrivileges);
    }

    public void rowFilter(QualifiedObjectName table, String identity, ViewExpression filter) {
        this.rowFilters.computeIfAbsent(new RowFilterKey(identity, table), key -> new ArrayList()).add(filter);
    }

    public void columnMask(QualifiedObjectName table, String column, String identity, ViewExpression mask) {
        this.columnMasks.computeIfAbsent(new ColumnMaskKey(identity, table, column), key -> new ArrayList()).add(mask);
    }

    public void reset() {
        this.denyPrivileges.clear();
        this.deniedCatalogs = s -> true;
        this.deniedTables = s -> true;
        this.rowFilters.clear();
        this.columnMasks.clear();
    }

    public void denyCatalogs(Predicate<String> deniedCatalogs) {
        this.deniedCatalogs = this.deniedCatalogs.and(deniedCatalogs);
    }

    public void denyTables(Predicate<SchemaTableName> deniedTables) {
        this.deniedTables = this.deniedTables.and(deniedTables);
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return super.filterCatalogs(identity, (Set)catalogs.stream().filter(this.deniedCatalogs).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return super.filterTables(context, catalogName, (Set)tableNames.stream().filter(this.deniedTables).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.IMPERSONATE_USER)) {
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanImpersonateUser(identity, userName);
        }
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.SET_USER)) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.EXECUTE_QUERY)) {
            AccessDeniedException.denyExecuteQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanExecuteQuery(identity);
        }
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, String queryOwner) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.VIEW_QUERY)) {
            AccessDeniedException.denyViewQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanViewQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public Set<String> filterQueriesOwnedBy(Identity identity, Set<String> owners) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.VIEW_QUERY)) {
            return ImmutableSet.of();
        }
        if (this.denyPrivileges.isEmpty()) {
            return super.filterQueriesOwnedBy(identity, owners);
        }
        return owners;
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, String queryOwner) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.KILL_QUERY)) {
            AccessDeniedException.denyKillQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanKillQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.CREATE_SCHEMA)) {
            AccessDeniedException.denyCreateSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateSchema(context, schemaName);
        }
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.DROP_SCHEMA)) {
            AccessDeniedException.denyDropSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropSchema(context, schemaName);
        }
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.RENAME_SCHEMA)) {
            AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameSchema(context, schemaName, newSchemaName);
        }
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SHOW_CREATE_TABLE)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanShowCreateTable(context, tableName);
        }
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_TABLE)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateTable(context, tableName);
        }
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_TABLE)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropTable(context, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_TABLE)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameTable(context, tableName, newTableName);
        }
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.COMMENT_TABLE)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetTableComment(context, tableName);
        }
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.ADD_COLUMN)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
        super.checkCanAddColumns(context, tableName);
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_COLUMN)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
        super.checkCanDropColumn(context, tableName);
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_COLUMN)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
        super.checkCanRenameColumn(context, tableName);
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.INSERT_TABLE)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanInsertIntoTable(context, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DELETE_TABLE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(context, tableName);
        }
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.CREATE_VIEW)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateView(context, viewName);
        }
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.RENAME_VIEW)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameView(context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.DROP_VIEW)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropView(context, viewName);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)context.getIdentity());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
        }
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), functionName, TestingPrivilegeType.GRANT_EXECUTE_FUNCTION)) {
            AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName, (Identity)context.getIdentity(), (Identity)grantee);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
        }
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), table.getSchemaTableName().getTableName(), TestingPrivilegeType.SHOW_COLUMNS)) {
            AccessDeniedException.denyShowColumns((String)table.getSchemaTableName().toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanShowColumns(context, table);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), catalogName + "." + propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columns) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SELECT_COLUMN)) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        for (String column : columns) {
            if (!this.shouldDenyPrivilege(context.getIdentity().getUser(), column, TestingPrivilegeType.SELECT_COLUMN)) continue;
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSelectFromColumns(context, tableName, columns);
        }
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), functionName, TestingPrivilegeType.EXECUTE_FUNCTION)) {
            AccessDeniedException.denyExecuteFunction((String)functionName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanExecuteFunction(context, functionName);
        }
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        List<ViewExpression> viewExpressions = this.rowFilters.get(new RowFilterKey(context.getIdentity().getUser(), tableName));
        if (viewExpressions != null) {
            return viewExpressions;
        }
        return super.getRowFilters(context, tableName);
    }

    @Override
    public List<ViewExpression> getColumnMasks(SecurityContext context, QualifiedObjectName tableName, String column, Type type) {
        List<ViewExpression> viewExpressions = this.columnMasks.get(new ColumnMaskKey(context.getIdentity().getUser(), tableName, column));
        if (viewExpressions != null) {
            return viewExpressions;
        }
        return super.getColumnMasks(context, tableName, column, type);
    }

    private boolean shouldDenyPrivilege(String userName, String entityName, TestingPrivilegeType type) {
        return this.shouldDenyPrivilege(TestingAccessControlManager.privilege(userName, entityName, type));
    }

    private boolean shouldDenyPrivilege(TestingPrivilege privilege) {
        TestingPrivilege testPrivilege = privilege;
        for (TestingPrivilege denyPrivilege : this.denyPrivileges) {
            if (!denyPrivilege.matches(testPrivilege)) continue;
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface ForSystemAccessControl {
    }

    private static class ColumnMaskKey {
        private final String identity;
        private final QualifiedObjectName table;
        private final String column;

        public ColumnMaskKey(String identity, QualifiedObjectName table, String column) {
            this.identity = identity;
            this.table = table;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnMaskKey that = (ColumnMaskKey)o;
            return this.identity.equals(that.identity) && this.table.equals(that.table) && this.column.equals(that.column);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.table, this.column);
        }
    }

    private static class RowFilterKey {
        private final String identity;
        private final QualifiedObjectName table;

        public RowFilterKey(String identity, QualifiedObjectName table) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.table = Objects.requireNonNull(table, "table is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowFilterKey that = (RowFilterKey)o;
            return this.identity.equals(that.identity) && this.table.equals(that.table);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.table);
        }
    }

    public static class TestingPrivilege {
        private final Optional<String> userName;
        private final String entityName;
        private final TestingPrivilegeType type;

        private TestingPrivilege(Optional<String> userName, String entityName, TestingPrivilegeType type) {
            this.userName = Objects.requireNonNull(userName, "userName is null");
            this.entityName = Objects.requireNonNull(entityName, "entityName is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean matches(TestingPrivilege testPrivilege) {
            return this.userName.map(name -> testPrivilege.userName.get().equals(name)).orElse(true) != false && this.entityName.equals(testPrivilege.entityName) && this.type == testPrivilege.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingPrivilege that = (TestingPrivilege)o;
            return Objects.equals(this.entityName, that.entityName) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityName, this.type});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userName", this.userName).add("entityName", (Object)this.entityName).add("type", (Object)this.type).toString();
        }
    }

    public static enum TestingPrivilegeType {
        SET_USER,
        IMPERSONATE_USER,
        EXECUTE_QUERY,
        VIEW_QUERY,
        KILL_QUERY,
        EXECUTE_FUNCTION,
        CREATE_SCHEMA,
        DROP_SCHEMA,
        RENAME_SCHEMA,
        SHOW_CREATE_TABLE,
        CREATE_TABLE,
        DROP_TABLE,
        RENAME_TABLE,
        COMMENT_TABLE,
        INSERT_TABLE,
        DELETE_TABLE,
        SHOW_COLUMNS,
        ADD_COLUMN,
        DROP_COLUMN,
        RENAME_COLUMN,
        SELECT_COLUMN,
        CREATE_VIEW,
        RENAME_VIEW,
        DROP_VIEW,
        CREATE_VIEW_WITH_SELECT_COLUMNS,
        GRANT_EXECUTE_FUNCTION,
        SET_SESSION;

    }
}

