/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.prestosql.Session;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class DateTimeTestingUtils {
    private DateTimeTestingUtils() {
    }

    public static SqlTimestamp sqlTimestampOf(int precision, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Session session) {
        return DateTimeTestingUtils.sqlTimestampOf(precision, year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey()), session.getTimeZoneKey(), session.toConnectorSession());
    }

    public static SqlTimestamp sqlTimestampOf(int precision, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone baseZone, TimeZoneKey timestampZone, ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            return SqlTimestamp.legacyFromMillis((int)precision, (long)new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, baseZone).getMillis(), (TimeZoneKey)timestampZone);
        }
        return DateTimeTestingUtils.sqlTimestampOf(precision, LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond)));
    }

    public static SqlTimestamp sqlTimestampOf(int precision, LocalDateTime dateTime) {
        return SqlTimestamp.fromMillis((int)precision, (long)(TimeUnit.DAYS.toMillis(dateTime.toLocalDate().toEpochDay()) + TimeUnit.NANOSECONDS.toMillis(dateTime.toLocalTime().toNanoOfDay())));
    }

    public static SqlTimestamp sqlTimestampOf(int precision, DateTime dateTime, Session session) {
        return DateTimeTestingUtils.sqlTimestampOf(precision, dateTime.getMillis(), session.toConnectorSession());
    }

    @Deprecated
    public static SqlTimestamp sqlTimestampOf(DateTime dateTime, Session session) {
        return DateTimeTestingUtils.sqlTimestampOf(3, dateTime.getMillis(), session.toConnectorSession());
    }

    @Deprecated
    public static SqlTimestamp sqlTimestampOf(long millis, ConnectorSession session) {
        return DateTimeTestingUtils.sqlTimestampOf(3, millis, session);
    }

    public static SqlTimestamp sqlTimestampOf(int precision, long millis, ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            return SqlTimestamp.legacyFromMillis((int)precision, (long)millis, (TimeZoneKey)session.getTimeZoneKey());
        }
        return SqlTimestamp.fromMillis((int)precision, (long)millis);
    }

    public static SqlTime sqlTimeOf(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Session session) {
        return DateTimeTestingUtils.sqlTimeOf(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, session.toConnectorSession());
    }

    public static SqlTime sqlTimeOf(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, ConnectorSession session) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond));
        return DateTimeTestingUtils.sqlTimeOf(time, session);
    }

    public static SqlTime sqlTimeOf(LocalTime time, ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            long millisUtc = LocalDate.ofEpochDay(0L).atTime(time).atZone(ZoneOffset.UTC).withZoneSameLocal(ZoneId.of(session.getTimeZoneKey().getId())).toInstant().toEpochMilli();
            return new SqlTime(millisUtc, session.getTimeZoneKey());
        }
        return new SqlTime(TimeUnit.NANOSECONDS.toMillis(time.toNanoOfDay()));
    }

    private static int millisToNanos(int millisOfSecond) {
        return Math.toIntExact(TimeUnit.MILLISECONDS.toNanos(millisOfSecond));
    }
}

