/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DecimalParseResult;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.StandardFunctionResolution;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.relational.optimizer.ExpressionOptimizer;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.type.JsonType;
import io.prestosql.type.Timestamps;
import io.prestosql.type.UnknownType;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout, Metadata metadata, Session session, boolean optimize) {
        Visitor visitor = new Visitor(metadata, types, layout, session.getTimeZoneKey(), SystemSessionProperties.isLegacyTimestamp(session));
        RowExpression result = (RowExpression)visitor.process((Node)expression, null);
        Objects.requireNonNull(result, "translated expression is null");
        if (optimize) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(metadata, session);
            return optimizer.optimize(result);
        }
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> types;
        private final Map<Symbol, Integer> layout;
        private final TimeZoneKey timeZoneKey;
        private final boolean isLegacyTimestamp;
        private final StandardFunctionResolution standardFunctionResolution;

        private Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout, TimeZoneKey timeZoneKey, boolean isLegacyTimestamp) {
            this.metadata = metadata;
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.layout = layout;
            this.timeZoneKey = timeZoneKey;
            this.isLegacyTimestamp = isLegacyTimestamp;
            this.standardFunctionResolution = new StandardFunctionResolution(metadata);
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            return Expressions.field(node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Void context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type = this.getType((Expression)node);
            if (JsonType.JSON.equals(type)) {
                return Expressions.call(this.metadata.resolveFunction(QualifiedName.of((String)"json_parse"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR})), type, Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
            }
            return Expressions.call(this.metadata.getCoercion((Type)VarcharType.VARCHAR, type), type, Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            long value = this.getType((Expression)node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : (this.isLegacyTimestamp ? DateTimeUtils.parseLegacyTime(this.timeZoneKey, node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(node.getValue()));
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            Object value;
            Type type = this.getType((Expression)node);
            if (type instanceof TimestampType) {
                int precision = ((TimestampType)type).getPrecision();
                value = this.isLegacyTimestamp ? Timestamps.parseLegacyTimestamp(precision, this.timeZoneKey, node.getValue()) : Timestamps.parseTimestamp(precision, node.getValue());
            } else if (type instanceof TimestampWithTimeZoneType) {
                int precision = ((TimestampWithTimeZoneType)type).getPrecision();
                value = Timestamps.parseTimestampWithTimeZone(precision, node.getValue());
            } else {
                throw new IllegalStateException("Unexpected type: " + type);
            }
            return Expressions.constant(value, type);
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(this.standardFunctionResolution.comparisonFunction(node.getOperator(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = (List)node.getArguments().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            ResolvedFunction resolvedFunction = ResolvedFunction.fromQualifiedName(node.getName()).orElseThrow(() -> new IllegalArgumentException("function call has not been resolved: " + node));
            return new CallExpression(resolvedFunction, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Void context) {
            Integer field = this.layout.get(Symbol.from((Expression)node));
            if (field != null) {
                return Expressions.field(field, this.getType((Expression)node));
            }
            return new VariableReferenceExpression(node.getName(), this.getType((Expression)node));
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Void context) {
            RowExpression body = (RowExpression)this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List<Type> argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = (RowExpression)this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return new SpecialForm(SpecialForm.Form.BIND, this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(this.standardFunctionResolution.arithmeticFunction(node.getOperator(), left.getType(), right.getType()), this.getType((Expression)node), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(this.metadata.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)expression.getType())), this.getType((Expression)node), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            SpecialForm.Form form;
            switch (node.getOperator()) {
                case AND: {
                    form = SpecialForm.Form.AND;
                    break;
                }
                case OR: {
                    form = SpecialForm.Form.OR;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown logical operator: " + node.getOperator());
                }
            }
            return new SpecialForm(form, (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getLeft(), context), (RowExpression)this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            Type returnType = this.getType((Expression)node);
            if (node.isTypeOnly()) {
                return Visitor.changeType(value, returnType);
            }
            if (node.isSafe()) {
                return Expressions.call(this.metadata.getCoercion(QualifiedName.of((String)"TRY_CAST"), value.getType(), returnType), returnType, value);
            }
            return Expressions.call(this.metadata.getCoercion(value.getType(), returnType), returnType, value);
        }

        private static RowExpression changeType(RowExpression value, Type targetType) {
            ChangeTypeVisitor visitor = new ChangeTypeVisitor(targetType);
            return value.accept(visitor, null);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = (List)node.getOperands().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            return new SpecialForm(SpecialForm.Form.COALESCE, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)((RowExpression)this.process((Node)node.getOperand(), context)));
            for (WhenClause clause : node.getWhenClauses()) {
                arguments.add((Object)new SpecialForm(SpecialForm.Form.WHEN, this.getType((Expression)clause), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context)));
            }
            Type returnType = this.getType((Expression)node);
            arguments.add((Object)node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(returnType)));
            return new SpecialForm(SpecialForm.Form.SWITCH, returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(this.getType((Expression)node)));
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = new SpecialForm(SpecialForm.Form.IF, this.getType((Expression)node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitDereferenceExpression(DereferenceExpression node, Void context) {
            RowType rowType = (RowType)this.getType(node.getBase());
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            Type returnType = this.getType((Expression)node);
            return new SpecialForm(SpecialForm.Form.DEREFERENCE, returnType, (RowExpression)this.process((Node)node.getBase(), context), Expressions.constant(index, (Type)IntegerType.INTEGER));
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)((RowExpression)this.process((Node)node.getCondition(), context))).add((Object)((RowExpression)this.process((Node)node.getTrueValue(), context)));
            if (node.getFalseValue().isPresent()) {
                arguments.add((Object)((RowExpression)this.process((Node)node.getFalseValue().get(), context)));
            } else {
                arguments.add((Object)Expressions.constantNull(this.getType((Expression)node)));
            }
            return new SpecialForm(SpecialForm.Form.IF, this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)((RowExpression)this.process((Node)node.getValue(), context)));
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression value : values.getValues()) {
                arguments.add((Object)((RowExpression)this.process((Node)value, context)));
            }
            return new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return this.notExpression(new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression)));
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return this.notExpression((RowExpression)this.process((Node)node.getValue(), context));
        }

        private RowExpression notExpression(RowExpression value) {
            return new CallExpression(this.metadata.resolveFunction(QualifiedName.of((String)"not"), TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN})), (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)value));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            return new SpecialForm(SpecialForm.Form.NULL_IF, this.getType((Expression)node), first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            return new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            return Expressions.call(this.metadata.resolveOperator(OperatorType.SUBSCRIPT, (List<? extends Type>)ImmutableList.of((Object)base.getType(), (Object)index.getType())), this.getType((Expression)node), base, index);
        }

        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.getItems().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            return new SpecialForm(SpecialForm.Form.ROW_CONSTRUCTOR, returnType, arguments);
        }

        private static class ChangeTypeVisitor
        implements RowExpressionVisitor<RowExpression, Void> {
            private final Type targetType;

            private ChangeTypeVisitor(Type targetType) {
                this.targetType = targetType;
            }

            @Override
            public RowExpression visitCall(CallExpression call, Void context) {
                return new CallExpression(call.getResolvedFunction(), this.targetType, call.getArguments());
            }

            @Override
            public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
                return new SpecialForm(specialForm.getForm(), this.targetType, specialForm.getArguments());
            }

            @Override
            public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
                return Expressions.field(reference.getField(), this.targetType);
            }

            @Override
            public RowExpression visitConstant(ConstantExpression literal, Void context) {
                return Expressions.constant(literal.getValue(), this.targetType);
            }

            @Override
            public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
                return new VariableReferenceExpression(reference.getName(), this.targetType);
            }
        }
    }
}

