/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import java.util.List;
import java.util.Objects;

public class SpecialForm
extends RowExpression {
    private final Form form;
    private final Type returnType;
    private final List<RowExpression> arguments;

    public SpecialForm(Form form, Type returnType, RowExpression ... arguments) {
        this(form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public SpecialForm(Form form, Type returnType, List<RowExpression> arguments) {
        this.form = Objects.requireNonNull(form, "form is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Type getType() {
        return this.returnType;
    }

    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.form.name() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecialForm that = (SpecialForm)o;
        return this.form == that.form && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.form, this.returnType, this.arguments});
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSpecialForm(this, context);
    }

    public static enum Form {
        IF,
        NULL_IF,
        SWITCH,
        WHEN,
        BETWEEN,
        IS_NULL,
        COALESCE,
        IN,
        AND,
        OR,
        DEREFERENCE,
        ROW_CONSTRUCTOR,
        BIND;

    }
}

