/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import java.util.HashMap;
import java.util.Objects;

public class NoDuplicatePlanNodeIdsChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        HashMap planNodeIds = new HashMap();
        PlanNodeSearcher.searchFrom(planNode).findAll().forEach(node -> planNodeIds.merge(node.getId(), node, this::reportDuplicateId));
    }

    private PlanNode reportDuplicateId(PlanNode first, PlanNode second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        Preconditions.checkArgument((boolean)first.getId().equals(second.getId()));
        throw new IllegalStateException(String.format("Generated plan contains nodes with duplicated id %s: %s and %s", first.getId(), first, second));
    }
}

