/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.SymbolMapper;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SetOperationNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final Metadata metadata;

    public UnaliasSymbolReferences(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(this.metadata, types), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Map<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>();
        private final Metadata metadata;
        private final TypeProvider types;

        private Rewriter(Metadata metadata, TypeProvider types) {
            this.metadata = metadata;
            this.types = types;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<Symbol, Symbol> newGroupingMappings = new HashMap<Symbol, Symbol>();
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            for (List<Symbol> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (Symbol output : groupingSet) {
                    newGroupingMappings.putIfAbsent(this.canonicalize(output), this.canonicalize(node.getGroupingColumns().get(output)));
                    newGroupingSet.add((Object)this.canonicalize(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            return new GroupIdNode(node.getId(), source, (List<List<Symbol>>)newGroupingSets.build(), newGroupingMappings, this.canonicalizeAndDistinct(node.getAggregationArguments()), this.canonicalize(node.getGroupIdSymbol()));
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ExplainAnalyzeNode(node.getId(), source, this.canonicalize(node.getOutputSymbol()), node.isVerbose());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List<Symbol> symbols = this.canonicalizeAndDistinct(node.getDistinctSymbols());
            return new MarkDistinctNode(node.getId(), source, this.canonicalize(node.getMarkerSymbol()), symbols, this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList.Builder mappings = ImmutableList.builder();
            for (UnnestNode.Mapping mapping : node.getMappings()) {
                mappings.add((Object)new UnnestNode.Mapping(this.canonicalize(mapping.getInput()), mapping.getOutputs()));
            }
            return new UnnestNode(node.getId(), source, this.canonicalizeAndDistinct(node.getReplicateSymbols()), (List<UnnestNode.Mapping>)mappings.build(), node.getOrdinalitySymbol(), node.getJoinType(), node.getFilter().map(this::canonicalize));
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            node.getWindowFunctions().forEach((symbol, function) -> {
                ResolvedFunction resolvedFunction = function.getResolvedFunction();
                List<Expression> arguments = this.canonicalize(function.getArguments());
                WindowNode.Frame canonicalFrame = this.canonicalize(function.getFrame());
                functions.put((Object)this.canonicalize((Symbol)symbol), (Object)new WindowNode.Function(resolvedFunction, arguments, canonicalFrame, function.isIgnoreNulls()));
            });
            return new WindowNode(node.getId(), source, this.canonicalizeAndDistinct(node.getSpecification()), (Map<Symbol, WindowNode.Function>)functions.build(), this.canonicalize(node.getHashSymbol()), this.canonicalize(node.getPrePartitionedInputs()), node.getPreSortedOrderPrefix());
        }

        private WindowNode.Frame canonicalize(WindowNode.Frame frame) {
            return new WindowNode.Frame(frame.getType(), frame.getStartType(), this.canonicalize(frame.getStartValue()), frame.getEndType(), this.canonicalize(frame.getEndValue()), frame.getOriginalStartValue(), frame.getOriginalEndValue());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return node;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List sources = (List)node.getSources().stream().map(context::rewrite).collect(ImmutableList.toImmutableList());
            this.mapExchangeNodeSymbols(node);
            ArrayList<List<Symbol>> inputs = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputs.add(new ArrayList());
            }
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int symbolIndex = 0; symbolIndex < node.getOutputSymbols().size(); ++symbolIndex) {
                Symbol canonicalOutput = this.canonicalize(node.getOutputSymbols().get(symbolIndex));
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
                for (int i = 0; i < node.getInputs().size(); ++i) {
                    List<Symbol> input = node.getInputs().get(i);
                    ((List)inputs.get(i)).add(this.canonicalize(input.get(symbolIndex)));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(node.getPartitioningScheme().getPartitioning().translate(this::canonicalize), (List<Symbol>)outputs.build(), this.canonicalize(node.getPartitioningScheme().getHashColumn()), node.getPartitioningScheme().isReplicateNullsAndAny(), node.getPartitioningScheme().getBucketToPartition());
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme().map(this::canonicalizeAndDistinct);
            return new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, sources, inputs, orderingScheme);
        }

        private void mapExchangeNodeSymbols(ExchangeNode node) {
            if (node.getInputs().size() == 1) {
                this.mapExchangeNodeOutputToInputSymbols(node);
                return;
            }
            HashMap<List<Symbol>, Symbol> inputsToOutputs = new HashMap<List<Symbol>, Symbol>();
            for (int symbolIndex = 0; symbolIndex < node.getOutputSymbols().size(); ++symbolIndex) {
                Symbol canonicalOutput = this.canonicalize(node.getOutputSymbols().get(symbolIndex));
                List<Symbol> canonicalInputs = this.canonicalizeExchangeNodeInputs(node, symbolIndex);
                Symbol output = (Symbol)inputsToOutputs.get(canonicalInputs);
                if (output == null || canonicalOutput.equals(output)) {
                    inputsToOutputs.put(canonicalInputs, canonicalOutput);
                    continue;
                }
                this.map(canonicalOutput, output);
            }
        }

        private void mapExchangeNodeOutputToInputSymbols(ExchangeNode node) {
            Preconditions.checkState((node.getInputs().size() == 1 ? 1 : 0) != 0);
            for (int symbolIndex = 0; symbolIndex < node.getOutputSymbols().size(); ++symbolIndex) {
                Symbol canonicalInput;
                Symbol canonicalOutput = this.canonicalize(node.getOutputSymbols().get(symbolIndex));
                if (canonicalOutput.equals(canonicalInput = this.canonicalize(node.getInputs().get(0).get(symbolIndex)))) continue;
                this.map(canonicalOutput, canonicalInput);
            }
        }

        private List<Symbol> canonicalizeExchangeNodeInputs(ExchangeNode node, int symbolIndex) {
            return (List)node.getInputs().stream().map(input -> this.canonicalize((Symbol)input.get(symbolIndex))).collect(ImmutableList.toImmutableList());
        }

        @Override
        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), this.canonicalizeAndDistinct(node.getOutputSymbols()), node.getOrderingScheme().map(this::canonicalizeAndDistinct), node.getExchangeType());
        }

        @Override
        public PlanNode visitOffset(OffsetNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.isWithTies()) {
                PlanNode source = context.rewrite(node.getSource());
                return new LimitNode(node.getId(), source, node.getCount(), node.getTiesResolvingScheme().map(this::canonicalizeAndDistinct), node.isPartial());
            }
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DistinctLimitNode(node.getId(), context.rewrite(node.getSource()), node.getLimit(), node.isPartial(), this.canonicalizeAndDistinct(node.getDistinctSymbols()), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new SampleNode(node.getId(), context.rewrite(node.getSource()), node.getSampleRatio(), node.getSampleType());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List canonicalizedRows = (List)node.getRows().stream().map(this::canonicalize).collect(ImmutableList.toImmutableList());
            List<Symbol> canonicalizedOutputSymbols = this.canonicalizeAndDistinct(node.getOutputSymbols());
            Preconditions.checkState((node.getOutputSymbols().size() == canonicalizedOutputSymbols.size() ? 1 : 0) != 0, (Object)"Values output symbols were pruned");
            return new ValuesNode(node.getId(), canonicalizedOutputSymbols, canonicalizedRows);
        }

        @Override
        public PlanNode visitTableDelete(TableDeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return node;
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DeleteNode(node.getId(), context.rewrite(node.getSource()), node.getTarget(), this.canonicalize(node.getRowId()), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), node.isOrderSensitive(), this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new TopNRowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getSpecification()), this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ProjectNode(node.getId(), source, this.canonicalize(node.getAssignments()));
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform(node.getOutputSymbols(), this::canonicalize);
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new EnforceSingleRowNode(node.getId(), source);
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new AssignUniqueId(node.getId(), source, node.getIdColumn());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List canonicalCorrelation = Lists.transform(node.getCorrelation(), this::canonicalize);
            return new ApplyNode(node.getId(), source, subquery, this.canonicalize(node.getSubqueryAssignments()), canonicalCorrelation, node.getOriginSubquery());
        }

        @Override
        public PlanNode visitCorrelatedJoin(CorrelatedJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List<Symbol> canonicalCorrelation = this.canonicalizeAndDistinct(node.getCorrelation());
            return new CorrelatedJoinNode(node.getId(), source, subquery, canonicalCorrelation, node.getType(), this.canonicalize(node.getFilter()), node.getOriginSubquery());
        }

        @Override
        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping);
            return mapper.map(node, source, node.getId());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new SortNode(node.getId(), source, this.canonicalizeAndDistinct(node.getOrderingScheme()), node.isPartial());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            List<JoinNode.EquiJoinClause> canonicalCriteria = this.canonicalizeJoinCriteria(node.getCriteria());
            Optional<Expression> canonicalFilter = node.getFilter().map(this::canonicalize);
            Optional<Symbol> canonicalLeftHashSymbol = this.canonicalize(node.getLeftHashSymbol());
            Optional<Symbol> canonicalRightHashSymbol = this.canonicalize(node.getRightHashSymbol());
            Map<DynamicFilterId, Symbol> canonicalDynamicFilters = this.canonicalizeAndDistinct(node.getDynamicFilters());
            if (node.getType() == JoinNode.Type.INNER) {
                canonicalCriteria.stream().forEach(clause -> this.map(clause.getRight(), clause.getLeft()));
            }
            List<Symbol> canonicalOutputs = this.canonicalizeAndDistinct(node.getOutputSymbols());
            List leftOutputSymbols = (List)canonicalOutputs.stream().filter(left.getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            List rightOutputSymbols = (List)canonicalOutputs.stream().filter(right.getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            return new JoinNode(node.getId(), node.getType(), left, right, canonicalCriteria, leftOutputSymbols, rightOutputSymbols, canonicalFilter, canonicalLeftHashSymbol, canonicalRightHashSymbol, node.getDistributionType(), node.isSpillable(), canonicalDynamicFilters, node.getReorderJoinStatsAndCost());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            PlanNode filteringSource = context.rewrite(node.getFilteringSource());
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinSymbol()), this.canonicalize(node.getFilteringSourceJoinSymbol()), this.canonicalize(node.getSemiJoinOutput()), this.canonicalize(node.getSourceHashSymbol()), this.canonicalize(node.getFilteringSourceHashSymbol()), node.getDistributionType());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            return new SpatialJoinNode(node.getId(), node.getType(), left, right, this.canonicalizeAndDistinct(node.getOutputSymbols()), this.canonicalize(node.getFilter()), this.canonicalize(node.getLeftPartitionSymbol()), this.canonicalize(node.getRightPartitionSymbol()), node.getKdbTree());
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), this.canonicalize(node.getLookupSymbols()), node.getOutputSymbols(), node.getAssignments());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode probeSource = context.rewrite(node.getProbeSource());
            PlanNode indexSource = context.rewrite(node.getIndexSource());
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()), this.canonicalize(node.getProbeHashSymbol()), this.canonicalize(node.getIndexHashSymbol()));
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new UnionNode(node.getId(), (List<PlanNode>)Rewriter.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalizeAndDistinct(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IntersectNode(node.getId(), (List<PlanNode>)Rewriter.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalizeAndDistinct(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new ExceptNode(node.getId(), (List<PlanNode>)Rewriter.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalizeAndDistinct(node.getOutputSymbols()));
        }

        private static ImmutableList.Builder<PlanNode> rewriteSources(SetOperationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)context.rewrite(source));
            }
            return rewrittenSources;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping);
            return mapper.map(node, source);
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        private void map(Symbol symbol, Symbol canonical) {
            Preconditions.checkArgument((!symbol.equals(canonical) ? 1 : 0) != 0, (String)"Can't map symbol to itself: %s", (Object)symbol);
            this.mapping.put(symbol, canonical);
        }

        private Assignments canonicalize(Assignments oldAssignments) {
            HashMap<Expression, Symbol> computedExpressions = new HashMap<Expression, Symbol>();
            Assignments.Builder assignments = Assignments.builder();
            for (Map.Entry<Symbol, Expression> entry : oldAssignments.getMap().entrySet()) {
                Expression expression = this.canonicalize(entry.getValue());
                if (expression instanceof SymbolReference) {
                    Symbol symbol = Symbol.from(expression);
                    if (!symbol.equals(entry.getKey())) {
                        this.map(entry.getKey(), symbol);
                    }
                } else if (DeterminismEvaluator.isDeterministic(expression, this.metadata) && !(expression instanceof NullLiteral)) {
                    Symbol computedSymbol = (Symbol)computedExpressions.get(expression);
                    if (computedSymbol == null) {
                        computedExpressions.put(expression, entry.getKey());
                    } else {
                        this.map(entry.getKey(), computedSymbol);
                    }
                }
                Symbol canonical = this.canonicalize(entry.getKey());
                assignments.put(canonical, expression);
            }
            return assignments.build();
        }

        private Optional<Symbol> canonicalize(Optional<Symbol> symbol) {
            if (symbol.isPresent()) {
                return Optional.of(this.canonicalize(symbol.get()));
            }
            return Optional.empty();
        }

        private Symbol canonicalize(Symbol symbol) {
            Symbol canonical = symbol;
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return canonical;
        }

        private List<Expression> canonicalize(List<Expression> values) {
            return (List)values.stream().map(this::canonicalize).collect(ImmutableList.toImmutableList());
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = this.canonicalize(Symbol.from((Expression)node));
                    return canonical.toSymbolReference();
                }
            }, (Expression)value);
        }

        private List<Symbol> canonicalizeAndDistinct(List<Symbol> outputs) {
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Symbol symbol : outputs) {
                Symbol canonical = this.canonicalize(symbol);
                if (!added.add(canonical)) continue;
                builder.add((Object)canonical);
            }
            return builder.build();
        }

        private Map<DynamicFilterId, Symbol> canonicalizeAndDistinct(Map<DynamicFilterId, Symbol> dynamicFilters) {
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<DynamicFilterId, Symbol> entry : dynamicFilters.entrySet()) {
                Symbol canonical = this.canonicalize(entry.getValue());
                if (!added.add(canonical)) continue;
                builder.put((Object)entry.getKey(), (Object)canonical);
            }
            return builder.build();
        }

        private WindowNode.Specification canonicalizeAndDistinct(WindowNode.Specification specification) {
            return new WindowNode.Specification(this.canonicalizeAndDistinct(specification.getPartitionBy()), specification.getOrderingScheme().map(this::canonicalizeAndDistinct));
        }

        private OrderingScheme canonicalizeAndDistinct(OrderingScheme orderingScheme) {
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : orderingScheme.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                if (!added.add(canonical)) continue;
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)orderingScheme.getOrdering(symbol));
            }
            return new OrderingScheme((List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build());
        }

        private Set<Symbol> canonicalize(Set<Symbol> symbols) {
            return (Set)symbols.stream().map(this::canonicalize).collect(ImmutableSet.toImmutableSet());
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private ListMultimap<Symbol, Symbol> canonicalizeSetOperationSymbolMap(ListMultimap<Symbol, Symbol> setOperationSymbolMap) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            HashSet<Symbol> addedSymbols = new HashSet<Symbol>();
            for (Map.Entry entry : setOperationSymbolMap.asMap().entrySet()) {
                Symbol canonicalOutputSymbol = this.canonicalize((Symbol)entry.getKey());
                if (!addedSymbols.add(canonicalOutputSymbol)) continue;
                builder.putAll((Object)canonicalOutputSymbol, (Iterable)((Collection)entry.getValue()).stream().map(this::canonicalize).collect(Collectors.toList()));
            }
            return builder.build();
        }
    }
}

