/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableDeleteOptimizer
implements PlanOptimizer {
    private final Metadata metadata;

    public TableDeleteOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        return SimplePlanRewriter.rewriteWith(new Optimizer(session, this.metadata, idAllocator), plan, null);
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;

        private Optimizer(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Optional<DeleteNode> delete = Optimizer.findNode(node.getSource(), DeleteNode.class);
            if (delete.isEmpty()) {
                return context.defaultRewrite(node);
            }
            Optional<TableScanNode> tableScan = Optimizer.findNode(delete.get().getSource(), TableScanNode.class);
            if (tableScan.isEmpty()) {
                return context.defaultRewrite(node);
            }
            TableScanNode tableScanNode = tableScan.get();
            if (!this.metadata.supportsMetadataDelete(this.session, tableScanNode.getTable())) {
                return context.defaultRewrite(node);
            }
            return new TableDeleteNode(this.idAllocator.getNextId(), tableScanNode.getTable(), (Symbol)Iterables.getOnlyElement(node.getOutputSymbols()));
        }

        private static <T> Optional<T> findNode(PlanNode source, Class<T> clazz) {
            while (source instanceof ExchangeNode) {
                List<PlanNode> sources = source.getSources();
                if (sources.size() != 1) {
                    return Optional.empty();
                }
                source = sources.get(0);
            }
            if (clazz.isInstance(source)) {
                return Optional.of(clazz.cast(source));
            }
            return Optional.empty();
        }
    }
}

