/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.SetOperationNodeInstantiator;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SetOperationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class SetOperationMerge {
    private final Rule.Context context;
    private final SetOperationNode node;
    private List<PlanNode> newSources;
    private final SetOperationNodeInstantiator instantiator;

    public SetOperationMerge(SetOperationNode node, Rule.Context context, SetOperationNodeInstantiator instantiator) {
        this.node = node;
        this.context = context;
        this.newSources = new ArrayList<PlanNode>();
        this.instantiator = instantiator;
    }

    public Optional<SetOperationNode> mergeFirstSource() {
        Lookup lookup = this.context.getLookup();
        List sources = this.node.getSources().stream().flatMap(lookup::resolveGroup).collect(Collectors.toList());
        if (!((PlanNode)sources.get(0)).getClass().equals(this.node.getClass())) {
            return Optional.empty();
        }
        ImmutableListMultimap.Builder newMappingsBuilder = ImmutableListMultimap.builder();
        SetOperationNode child = (SetOperationNode)sources.get(0);
        this.addMergedMappings(child, 0, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        for (int i = 1; i < sources.size(); ++i) {
            PlanNode source = (PlanNode)sources.get(i);
            this.addOriginalMappings(source, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        }
        return Optional.of(this.instantiator.create(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols()));
    }

    public Optional<SetOperationNode> merge() {
        Lookup lookup = this.context.getLookup();
        List sources = this.node.getSources().stream().flatMap(lookup::resolveGroup).collect(Collectors.toList());
        if (sources.stream().noneMatch(this.node.getClass()::isInstance)) {
            return Optional.empty();
        }
        ImmutableListMultimap.Builder newMappingsBuilder = ImmutableListMultimap.builder();
        for (int i = 0; i < sources.size(); ++i) {
            PlanNode source = (PlanNode)sources.get(i);
            if (this.node.getClass().equals(source.getClass())) {
                SetOperationNode setOperationNode = (SetOperationNode)source;
                this.addMergedMappings(setOperationNode, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
                continue;
            }
            this.addOriginalMappings(source, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        }
        return Optional.of(this.instantiator.create(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols()));
    }

    private void addMergedMappings(SetOperationNode child, int childIndex, ImmutableListMultimap.Builder<Symbol, Symbol> newMappingsBuilder) {
        this.newSources.addAll(child.getSources());
        for (Map.Entry mapping : this.node.getSymbolMapping().asMap().entrySet()) {
            Symbol input = (Symbol)Iterables.get((Iterable)((Iterable)mapping.getValue()), (int)childIndex);
            newMappingsBuilder.putAll((Object)((Symbol)mapping.getKey()), (Iterable)child.getSymbolMapping().get((Object)input));
        }
    }

    private void addOriginalMappings(PlanNode child, int childIndex, ImmutableListMultimap.Builder<Symbol, Symbol> newMappingsBuilder) {
        this.newSources.add(child);
        for (Map.Entry mapping : this.node.getSymbolMapping().asMap().entrySet()) {
            newMappingsBuilder.put((Object)((Symbol)mapping.getKey()), (Object)((Symbol)Iterables.get((Iterable)((Iterable)mapping.getValue()), (int)childIndex)));
        }
    }
}

