/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(ImplementFilteredAggregations::hasFilters);
    private final Metadata metadata;

    public ImplementFilteredAggregations(Metadata metadata) {
        this.metadata = metadata;
    }

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getFilter().isPresent() && e.getMask().isEmpty());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        ImmutableList.Builder maskSymbols = ImmutableList.builder();
        boolean aggregateWithoutFilterPresent = false;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregationNode.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            Optional<Symbol> mask = aggregation.getMask();
            if (aggregation.getFilter().isPresent()) {
                Symbol filter = aggregation.getFilter().get();
                Symbol symbol = context.getSymbolAllocator().newSymbol(filter.getName(), (Type)BooleanType.BOOLEAN);
                Verify.verify((boolean)mask.isEmpty(), (String)"Expected aggregation without mask symbols, see Rule pattern", (Object[])new Object[0]);
                newAssignments.put(symbol, (Expression)new SymbolReference(filter.getName()));
                mask = Optional.of(symbol);
                maskSymbols.add((Object)symbol.toSymbolReference());
            } else {
                aggregateWithoutFilterPresent = true;
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), Optional.empty(), aggregation.getOrderingScheme(), mask));
        }
        BooleanLiteral predicate = BooleanLiteral.TRUE_LITERAL;
        if (!aggregationNode.hasNonEmptyGroupingSet() && !aggregateWithoutFilterPresent) {
            predicate = ExpressionUtils.combineDisjunctsWithDefault(this.metadata, (Collection<Expression>)maskSymbols.build(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
        newAssignments.putIdentities(aggregationNode.getSource().getOutputSymbols());
        return Rule.Result.ofPlanNode(new AggregationNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), aggregationNode.getSource(), newAssignments.build()), (Expression)predicate), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregationNode.getGroupingSets(), (List<Symbol>)ImmutableList.of(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
    }
}

