/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.ExpressionAnalyzer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Parameter;
import java.util.Map;
import javax.inject.Inject;

public class TypeAnalyzer {
    private final SqlParser parser;
    private final Metadata metadata;

    @Inject
    public TypeAnalyzer(SqlParser parser, Metadata metadata) {
        this.parser = parser;
        this.metadata = metadata;
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, TypeProvider inputTypes, Iterable<Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressions(session, this.metadata, new AllowAllAccessControl(), this.parser, inputTypes, expressions, (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of(), WarningCollector.NOOP, false).getExpressionTypes();
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, TypeProvider inputTypes, Expression expression) {
        return this.getTypes(session, inputTypes, (Iterable<Expression>)ImmutableList.of((Object)expression));
    }

    public Type getType(Session session, TypeProvider inputTypes, Expression expression) {
        return this.getTypes(session, inputTypes, expression).get(NodeRef.of((Node)expression));
    }
}

