/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.type.JsonType;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(Metadata metadata, ConnectorSession session, Map<NodeRef<Expression>, Type> types, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(metadata, types).process((Node)node, session);
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, ConnectorSession> {
        private final Metadata metadata;
        private final InterpretedFunctionInvoker functionInvoker;
        private final Map<NodeRef<Expression>, Type> types;

        private LiteralVisitor(Metadata metadata, Map<NodeRef<Expression>, Type> types) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.functionInvoker = new InterpretedFunctionInvoker(metadata);
            this.types = Objects.requireNonNull(types, "types is null");
        }

        protected Object visitLiteral(Literal node, ConnectorSession session) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, ConnectorSession context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, ConnectorSession session) {
            return node.getSlice();
        }

        protected Object visitCharLiteral(CharLiteral node, ConnectorSession context) {
            return node.getSlice();
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitGenericLiteral(GenericLiteral node, ConnectorSession session) {
            Type type;
            try {
                type = this.metadata.fromSqlType(node.getType());
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)node, "Unknown type: %s", node.getType());
            }
            if (JsonType.JSON.equals(type)) {
                ResolvedFunction resolvedFunction = this.metadata.resolveFunction(QualifiedName.of((String)"json_parse"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
                return this.functionInvoker.invoke(resolvedFunction, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            try {
                ResolvedFunction resolvedFunction = this.metadata.getCoercion((Type)VarcharType.VARCHAR, type);
                return this.functionInvoker.invoke(resolvedFunction, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "No literal form for type %s", type);
            }
        }

        protected Long visitTimeLiteral(TimeLiteral node, ConnectorSession session) {
            Type type = this.types.get(NodeRef.of((Node)node));
            if (type instanceof TimeType) {
                if (session.isLegacyTimestamp()) {
                    return DateTimeUtils.parseLegacyTime(session.getTimeZoneKey(), node.getValue());
                }
                return DateTimeUtils.parseTimeWithoutTimeZone(node.getValue());
            }
            if (type instanceof TimeWithTimeZoneType) {
                return DateTimeUtils.parseTimeWithTimeZone(node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }

        protected Object visitTimestampLiteral(TimestampLiteral node, ConnectorSession session) {
            Type type = this.types.get(NodeRef.of((Node)node));
            if (type instanceof TimestampType) {
                int precision = ((TimestampType)type).getPrecision();
                if (session.isLegacyTimestamp()) {
                    return Timestamps.parseLegacyTimestamp(precision, session.getTimeZoneKey(), node.getValue());
                }
                return Timestamps.parseTimestamp(precision, node.getValue());
            }
            if (type instanceof TimestampWithTimeZoneType) {
                int precision = ((TimestampWithTimeZoneType)type).getPrecision();
                return Timestamps.parseTimestampWithTimeZone(precision, node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, ConnectorSession session) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, ConnectorSession session) {
            return null;
        }
    }
}

