/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Map;
import java.util.function.Function;

public final class ExpressionSymbolInliner {
    private final Function<Symbol, Expression> mapping;

    public static Expression inlineSymbols(Map<Symbol, ? extends Expression> mapping, Expression expression) {
        return ExpressionSymbolInliner.inlineSymbols(mapping::get, expression);
    }

    public static Expression inlineSymbols(Function<Symbol, Expression> mapping, Expression expression) {
        return new ExpressionSymbolInliner(mapping).rewrite(expression);
    }

    private ExpressionSymbolInliner(Function<Symbol, Expression> mapping) {
        this.mapping = mapping;
    }

    private Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private class Visitor
    extends ExpressionRewriter<Void> {
        private final Multiset<String> excludedNames = HashMultiset.create();

        private Visitor() {
        }

        public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.excludedNames.contains((Object)node.getName())) {
                return node;
            }
            Expression expression = ExpressionSymbolInliner.this.mapping.apply(Symbol.from((Expression)node));
            Preconditions.checkState((expression != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return expression;
        }

        public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                this.excludedNames.add((Object)argument.getName().getValue());
            }
            Expression result = treeRewriter.defaultRewrite((Expression)node, (Object)context);
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                Verify.verify((boolean)this.excludedNames.remove((Object)argument.getName().getValue()));
            }
            return result;
        }
    }
}

