/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.Constant;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.type.UnknownType;
import java.util.List;

public class IsNullCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(ResolvedFunction resolvedFunction, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        RowExpression argument = arguments.get(0);
        if (argument.getType().equals((Object)UnknownType.UNKNOWN)) {
            return Constant.loadBoolean((boolean)true);
        }
        BytecodeNode value = generatorContext.generate(argument);
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("is null").append(value).pop(argument.getType().getJavaType()).append((BytecodeNode)wasNull);
        block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

