/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import java.util.List;
import java.util.Objects;

public class InvokeFunctionBytecodeExpression
extends BytecodeExpression {
    private final BytecodeNode invocation;
    private final String oneLineDescription;

    public static BytecodeExpression invokeFunction(Scope scope, CachedInstanceBinder cachedInstanceBinder, ResolvedFunction resolvedFunction, Metadata metadata, BytecodeExpression ... parameters) {
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(resolvedFunction, "function is null");
        Objects.requireNonNull(metadata, "metadata is null");
        return new InvokeFunctionBytecodeExpression(scope, cachedInstanceBinder.getCallSiteBinder(), resolvedFunction, metadata, (List<BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    private InvokeFunctionBytecodeExpression(Scope scope, CallSiteBinder binder, ResolvedFunction resolvedFunction, Metadata metadata, List<BytecodeExpression> parameters) {
        super(ParameterizedType.type((Class)Primitives.unwrap((Class)metadata.getType(resolvedFunction.getSignature().getReturnType()).getJavaType())));
        this.invocation = BytecodeUtils.generateInvocation(scope, resolvedFunction, metadata, (List)parameters.stream().map(BytecodeNode.class::cast).collect(ImmutableList.toImmutableList()), binder);
        this.oneLineDescription = resolvedFunction.getSignature().getName() + "(" + Joiner.on((String)", ").join(parameters) + ")";
    }

    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return this.invocation;
    }

    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

