/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.gen.Binding;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;

public final class CallSiteBinder {
    private int nextId;
    private final Map<Long, MethodHandle> bindings = new HashMap<Long, MethodHandle>();

    public Binding bind(MethodHandle method) {
        long bindingId = this.nextId++;
        Binding binding = new Binding(bindingId, method.type());
        this.bindings.put(bindingId, method);
        return binding;
    }

    public Binding bind(Object constant, Class<?> type) {
        return this.bind(MethodHandles.constant(type, constant));
    }

    public Map<Long, MethodHandle> getBindings() {
        return ImmutableMap.copyOf(this.bindings);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nextId", this.nextId).add("bindings", this.bindings).toString();
    }
}

