/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Analysis> {
    private final Metadata metadata;

    public WindowFunctionValidator(Metadata metadata) {
        this.metadata = metadata;
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Objects.requireNonNull(analysis, "analysis is null");
        ResolvedFunction resolvedFunction = analysis.getResolvedFunction(functionCall);
        if (resolvedFunction != null && functionCall.getWindow().isEmpty() && this.metadata.getFunctionMetadata(resolvedFunction).getKind() == FunctionKind.WINDOW) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER, (Node)functionCall, "Window function %s requires an OVER clause", resolvedFunction.getSignature().getName());
        }
        return super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

