/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.collect.ImmutableList;
import io.prestosql.connector.system.KillQueryProcedure;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlUtil;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.HttpRequestSessionContext;
import io.prestosql.server.security.ResourceSecurity;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.GroupProvider;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/ui/api/query")
public class UiQueryResource {
    private final DispatchManager dispatchManager;
    private final AccessControl accessControl;
    private final GroupProvider groupProvider;

    @Inject
    public UiQueryResource(DispatchManager dispatchManager, AccessControl accessControl, GroupProvider groupProvider) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    public List<BasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String stateFilter, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        List<BasicQueryInfo> queries = this.dispatchManager.getQueries();
        queries = AccessControlUtil.filterQueries(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.accessControl, this.groupProvider), queries, this.accessControl);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BasicQueryInfo queryInfo : queries) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)queryInfo);
        }
        return builder.build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        Optional<QueryInfo> queryInfo = this.dispatchManager.getFullQueryInfo(queryId);
        if (queryInfo.isPresent()) {
            try {
                AccessControlUtil.checkCanViewQueryOwnedBy(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.accessControl, this.groupProvider), queryInfo.get().getSession().getUser(), this.accessControl);
                return Response.ok((Object)queryInfo.get()).build();
            }
            catch (AccessDeniedException e) {
                throw new ForbiddenException();
            }
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message), servletRequest, httpHeaders);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @PUT
    @Path(value="{queryId}/preempted")
    public Response preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message), servletRequest, httpHeaders);
    }

    private Response failQuery(QueryId queryId, PrestoException queryException, HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryId);
            AccessControlUtil.checkCanKillQueryOwnedBy(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.accessControl, this.groupProvider), queryInfo.getSession().getUser(), this.accessControl);
            if (queryInfo.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.dispatchManager.failQuery(queryId, queryException);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }
}

